export enum Gender {
    MALE = 'male',
    FEMALE = 'female',
    OTHER = 'other'
}

export enum Role {
    SUPER_ADMIN = 'super admin',
    ADMIN = 'admin',
    STAFF = 'staff',
    PROVOST = 'provost',
}

export enum Fee_Type {
    FORM = 'prof application form',
    PART_FORM = 'part application form',
    PUTME = 'putme screening',
    ACCEPTANCE = 'acceptance',
    TUITION = 'tuition',
    ID_CARD = 'ID card'
}

// export enum Invoice_Type {
//     FORM = 'prof_form',
//     PART_FORM = 'part_form',
//     PUTME = 'putme screening',
//     ACCEPTANCE = 'acceptance',
//     TUTION = 'tution',
//     ACCEPTANCE_TUTION = 'acceptance_tution'
// }
export enum Invoice_Type {
    FORM = Fee_Type.FORM,
    PART_FORM = Fee_Type.PART_FORM,
    PUTME = Fee_Type.PUTME,
    ACCEPTANCE = Fee_Type.ACCEPTANCE,
    TUITION = Fee_Type.TUITION,
    ACCEPTANCE_TUTION = `${Fee_Type.ACCEPTANCE}_${Fee_Type.TUITION}`
}

export enum Course_Type {
    CORE = 'C',
    COGNATE = 'R',
    ELECTIVE = 'E'
}

export enum Semester {
    FIRST = 'first',
    SECOND = 'second'
}

export enum Level {
    _100 = '100',
    _200 = '200',
    _13 = '13 weeks'
}

export enum Status {
    PENDING = 'pending',
    ACCEPTED = 'accepted',
    REJECTED = 'rejected'
}

export enum Review {
    ACCEPTED = 'accepted',
    REJECTED = 'rejected'
}

// export enum PAYMENT_Status {
//     COMPLETED = 'completed',
//     PENDING = 'pending',
// }

// export enum PROGRAMMES {
//     NID = 'NID',
//     PROF = 'Professional',
// }

export enum PROGRAMMES {
    NID = 'nid',
    PROF = 'professional',
}

export enum PROF_Stream {
    BASIC = 'basic',
    ADVANCED = 'advanced',
}

export enum NID_Stream {
    FULL = 'full',
    PART = 'part',
}

export enum Stream {
    FULL = 'full',
    PART = 'part',
    BASIC = 'basic',
    ADVANCED = 'advanced',
}

// export enum Stream_2 {
//     NID = 'nid',
//     BASIC = 'basic',
//     ADVANCED = 'advanced',
// }

export enum Category {
    ALL = '*',
    FULL = 'full',
    PART = 'part',
    BASIC = 'basic',
    ADVANCED = 'advanced',
    PROFESSIONAL = 'basic_advanced',
    NID = 'full_part'
}

export enum Permisions {
    SUDO = '*',
    READ_ADMIN = 'admin.read',
    UPDATE_ADMIN = 'admin.update',
    DELETE_ADMIN = 'admin.delete',
    CREATE_ADMIN = 'admin.create',
    SUDO_ADMIN = 'admin.*',
    READ_COURSE = 'course.read',
    UPDATE_COURSE = 'course.update',
    DELETE_COURSE= 'course.delete',
    CREATE_COURSE = 'course.create',
    SUDO_COURSE = 'course.*',
    READ_STUDENT = 'student.read',
    UPDATE_STUDENT = 'student.update',
    DELETE_STUDENT= 'student.delete',
    CREATE_STUDENT = 'student.create',
    SUDO_STUDENT = 'student.*',
    READ_RESULT = 'result.read',
    UPDATE_RESULT = 'result.update',
    DELETE_RESULT = 'result.delete',
    CREATE_RESULT = 'result.create',
    SUDO_RESULT = 'result.*',
    READ_APPLICATION = 'application.read',
    UPDATE_APPLICATION = 'application.update',
    DELETE_APPLICATION= 'application.delete',
    CREATE_APPLICATION = 'application.create',
    SUDO_APPLICATION = 'application.*',
}

export const permission_divider = " =::"

export enum COD {
    DISTINCTION = 'Distinction',
    UPPER_CREDIT = 'Upper Credit',
    LOWER_CREDIT = 'Lower Credit',
    PASS = 'pass'
}