import twilo from 'twilio';

const accountSid = process.env.TWILIO_ACCOUNT_SID;
const authToken = process.env.TWILIO_AUTH_TOKEN;
const client = twilo(accountSid, authToken);

export const sendSMS = async (recipient: string, msg: string) => {
  try {
    const message = await client.messages.create({
      body: msg,
      messagingServiceSid: 'MGXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
      to: recipient
    })
  
    if(!message) throw new Error('Failed to send sms');
  
    console.log(message, 'successssssss');
    
  } catch (error) {
    console.log('Errorror', error)
  }
}



// client.messages
//   .create({
//     body: 'You have an appointment with Owl, Inc. on Friday, November 3 at 4:00 PM. Reply C to confirm.',
//     messagingServiceSid: 'MGXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
//     to: '+15558675310'
//   })
//   .then(message => console.log(message.sid));
