import { Service } from "typedi";
import axios, { Axios, AxiosResponse } from "axios";
import { AsyncFunc } from "../../Interfaces";
import { CheckoutDetails } from "../../Interfaces/paystack";

@Service()
class Paystack {
    constructor() {
        this.token = `${process.env.PAYSTACK_SECRET_KEY}`;
        this.url = process.env.PAYSTACK_BASEURL!

        this.instantiateApi();
    }

    private token: string;
    private url: string;
    private api: any

    private instantiateApi = () => {
        this.api = axios.create({
            baseURL: this.url,
            headers: {
                "Content-Type": "application/json",
                Authorization: `Bearer ${this.token}`
            }
        })
    }

    private asyncWrapper<T>(fn: AsyncFunc<T, AxiosResponse>) {
        return async (arg: T) => {
            try {
                const res = await fn(arg);

                if (res.status) {
                    return res.data.data;
                }

                throw new Error(res.data)
            } catch (error) {
                console.log(error)
                throw error;
            }
        }
    }

    public initializeTransaction = this.asyncWrapper(
        async (data: CheckoutDetails) => {
            return await this.api.post("/transaction/initialize", data);
        }
    )

    public verifyTransaction = this.asyncWrapper(
        async (reference: string[]) => {
            return await this.api.get(`/transaction/verify/${reference}`);
        }
    )


}

export default Paystack;
