import { Service } from "typedi";
import axios, { Axios, AxiosResponse } from "axios";
// import { PAYPAL_CLIENT_ID, PAYPAL_SECRET , PAYPAL_ACCESS_TOKEN} from "../../Config";
const { PAYPAL_CLIENT_ID, PAYPAL_SECRET , PAYPAL_ACCESS_TOKEN} = process.env;

@Service()
class Paypal {
  constructor() {
    this.secretKey = PAYPAL_SECRET!;
    this.url = "https://api-m.sandbox.paypal.com"

    // this.instantiateApi();
  }

  private secretKey: string;
  private url: string;
  private api!: Axios;

  private instantiateApi = async () => {
    this.api = axios.create({
      baseURL: this.url,
      headers: {
        "Content-Type": "application/json",
        // Authorization: `Bearer ${await this.generateAccessToken()}`
        Authorization: `Bearer ${PAYPAL_ACCESS_TOKEN}`
      }
    })
    console.log(await this.generateAccessToken())
  }

  private generateAccessToken = async () => {
    try {
      if (!PAYPAL_CLIENT_ID || !PAYPAL_SECRET) {
        throw new Error("MISSING_API_CREDENTIALS");
      }
      const auth = Buffer.from(
        PAYPAL_CLIENT_ID + ":" + PAYPAL_SECRET,
      ).toString("base64");
      const response = await fetch(`${this.url}/v1/oauth2/token`, {
        method: "POST",
        body: "grant_type=client_credentials",
        headers: {
          Authorization: `Basic ${auth}`,
        },
      });

      const data = await response.json();

      console.log(data.access_token, 'accessToken')

      return data.access_token;
    } catch (error) {
      throw error;
    }
  }

  public createOrder = async (cart: any) => {
    // use the cart information passed from the front-end to calculate the purchase unit details
    console.log(
      "shopping cart information passed from the frontend createOrder() callback:",
      cart,
    );

    // const accessToken = await this.generateAccessToken();
    // const url = `${base}/v2/checkout/orders`;
    const payload = {
      intent: "CAPTURE",
      purchase_units: [
        // {
        //   amount: {
        //     currency_code: "USD",
        //     value: cart.price,
        //   },
        //   ...cart
        // },
        {
          "amount": {
            "currency_code": "USD",
            "value": "100.00"
          }
        }
      ],
      "name": "examples.link",
      "premium": true,
      "purchaseType": "registration",
      "renewalPrice": 125,
      "available": true
    };

    // return await this.api.post(`/v2/checkout/orders`, payload);

    const response = await fetch(`${this.url}/v2/checkout/orders`, {
      headers: {
        "Content-Type": "application/json",
        // Authorization: `Bearer ${await this.generateAccessToken()}`,
        Authorization: `Bearer ${PAYPAL_ACCESS_TOKEN}`
        // Uncomment one of these to force an error for negative testing (in sandbox mode only). Documentation:
        // https://developer.paypal.com/tools/sandbox/negative-testing/request-headers/
        // "PayPal-Mock-Response": '{"mock_application_codes": "MISSING_REQUIRED_PARAMETER"}'
        // "PayPal-Mock-Response": '{"mock_application_codes": "PERMISSION_DENIED"}'
        // "PayPal-Mock-Response": '{"mock_application_codes": "INTERNAL_SERVER_ERROR"}'
      },
      method: "POST",
      body: JSON.stringify(payload),
      // body: payload,
    });

    return response.json();
  }

  public capture = async (id: string) => {
    // /v2/checkout/orders/${orderID}/capture
    // return await this.api.post(`/v2/checkout/orders/${id}/capture`);

    const response = await fetch(`${this.url}/v2/checkout/orders/${id}/capture`, {
      headers: {
        "Content-Type": "application/json",
        // Authorization: `Bearer ${await this.generateAccessToken()}`,
        Authorization: `Bearer ${PAYPAL_ACCESS_TOKEN}`
      },
      method: "POST",
    });

    return await response.json();
  }

}

export default Paypal;
