import jwt from 'jsonwebtoken';
import { NID_Stream, PROF_Stream, Role, Status } from '../types/enum';

type PROF_ASPIRANT = {
  first_name: string,
  last_name: string,
  email: string,
  stream: PROF_Stream
  middle_name: string,
  phone: any
}

export const generateProfAspirantFormToken = (data: PROF_ASPIRANT): string => {
  return jwt.sign({ ...data }, process.env.JWT_SECRET!);
}

export const decodeProfAspirantFormToken = (token: string): PROF_ASPIRANT => {
  return jwt.decode(token) as PROF_ASPIRANT;
}

export const generateProfAspirantToken = (data: { id: number, email: string, stream: PROF_Stream, status: Status }): string => {
  return jwt.sign(data, process.env.JWT_SECRET!, { expiresIn: "1d" });
}

export const decodeProfAspirantToken = (token: string): { id: number, email: string, stream: PROF_Stream, status: Status } => {
  return jwt.decode(token) as { id: number, email: string, stream: PROF_Stream, status: Status };
}

export const generateAspirantToken = (data: { id: number, email: string, stream: NID_Stream, jamb_reg?: string }): string => {
  return jwt.sign({ ...data }, process.env.JWT_SECRET!, { expiresIn: "1d" });
}

export const decodeAspirantToken = (token: string): { id: number, email: string, stream: NID_Stream, jamb_reg?: string } => {
  return jwt.decode(token) as { id: number, email: string, stream: NID_Stream, status: Status, jamb_reg?: string };
}

export const generateToken = (data: { matric_no: string, id: number }): string => {
  return jwt.sign(data, process.env.JWT_SECRET!, { expiresIn: "1d" });
}

export const decodeToken = (token: string): { matric_no: string, id: number } => {
  return jwt.decode(token) as { matric_no: string, id: number };
}

export const generateAdminToken = (data: { email: string, id: number, role: Role }): string => {
  return jwt.sign(data, process.env.JWT_SECRET!, { expiresIn: '1d'});
}

export const decodeAdminToken = (token: string): { email: string, id: number, role: Role } => {
  return jwt.decode(token) as { email: string, id: number, role: Role };
}





// export const encodeOTP = (code: string, email: string): string => {
//   return jwt.sign({ code, email }, process.env.JWT_SECRET!, { expiresIn: "15m" })
// }

// export const decodeOTP = (token: string): { email: string, code: string } => {
//   return jwt.decode(token) as { email: string, code: string };
// }



// export const decodeStaffToken = (token: string): { staff_no: string, id: number, role: Role } => {
//   return jwt.decode(token) as { staff_no: string, id: number, role: Role };
// }




// const adm_no = await generateRegNo();
//             console.log(adm_no, 'new_adm_no');