import XLSX from 'xlsx';


export const excelToJson = (dataBuffer: Buffer, sheet: string) => {
    // Read the Excel file from a buffer
    const workbook = XLSX.read(dataBuffer, { type: 'buffer' });

    //   const firstSheetName = workbook.SheetNames[0];
    const sheetIndex = workbook.SheetNames.findIndex(sht => sht === sheet);
    const sheetName = workbook.SheetNames[sheetIndex]
    const worksheet = workbook.Sheets[sheetName];
    const jsonData = XLSX.utils.sheet_to_json(worksheet);

    return jsonData as any[]
}
