import { Router } from "express";
import { Route } from "../../Interfaces/router";
import { Inject, Service } from "typedi";
import StudentValidation from "../../Validations/Student";
import StudentController from "../../Controller/Student";
import { AuthMiddleware } from "../../Middleware";
import Injector from "../../Middleware/injector";

@Service() 
class StudentRouter implements Route {
    public path: string;
    public router: Router;

    constructor(
        @Inject() private readonly studentValidation: StudentValidation,
        @Inject() private readonly studentController: StudentController,
        private readonly authMiddleWare: AuthMiddleware, 
        private readonly injector: Injector,
    ) {
        this.path = '/student'
        this.router = Router()

        this.initializeRoutes()
    }

    private initializeRoutes () {
        this.router.get('/sessions', this.studentController.getAcademicSessions)

        this.router.post('/signin', this.studentValidation.loginValidator, this.studentController.login);
        this.router.get('/', this.authMiddleWare.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.studentController.getProfile)
        this.router.get('/result', this.authMiddleWare.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.studentValidation.validateGetResult, this.studentController.getResult)
        this.router.get('/admission_letter', this.authMiddleWare.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.studentController.generateAdmissionLetter)
        this.router.get('/exam_slip', this.authMiddleWare.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.studentValidation.validateGetExamSlip, this.studentController.getExamSlip)
        this.router.get('/intership_letter', this.authMiddleWare.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.studentValidation.validateGetInternLetter)
        
        
        
        
        
    }
}

export default StudentRouter;