import { NextFunction, Request, Response } from "express";
import { Service } from "typedi";
import StudentAdapter from "../Database/adapters/studentAdapter";
import { serverError } from "../Utils/api_response";
import CourseAdapter from "../Database/adapters/courseAdapter";
import FeeAdapter from "../Database/adapters/feeAdapter";

@Service()
class Injector {
    constructor(
        private readonly studentAdapter: StudentAdapter,
        private readonly courseAdaper: CourseAdapter,
        private readonly feeAdapter: FeeAdapter
    ) { }

    // public injectProgramme = async (req: Request, res: Response, next: NextFunction) => {
    //     try {
    //         const { auth_user } = req.body;

    //         const programme = this.feeAdapter.DBGetProgramme(auth_user.prog_level);

    //         req.body = {
    //             ...req.body,
    //             programme: {
    //                 ...programme
    //             }
    //         }

    //         return next();
    //     } catch (error) {
    //         return serverError(res); 
    //     }
    // }

    // public injectEnrollmentData = async (req: Request, res: Response, next: NextFunction) => {
    //     try {
    //         const { auth_user } = req.body;
    
    //         const data = await this.studentAdapter.DBGetEnrollmentData(auth_user.id);
    
    //         req.body = {
    //             ...req.body,
    //             auth_user: {
    //                 ...auth_user,
    //                 ...data
    //             }
    //         }
    
    //         return next();
            
    //     } catch (error) {
    //         return serverError(res);   
    //     }
    // }

    public injectCurrentSessionAndDiet = async (req: Request, res: Response, next: NextFunction) => {
        try {
            const session = await this.courseAdaper.DBGetCurrentSessionAndDiet();

            req.body.session = session;

            return next();
        } catch (error) {
            return serverError(res);
        }
    }
}

export default Injector;