import jwt from 'jsonwebtoken';
import { unAuthorized } from "../Utils/api_response";
import { decodeAspirantToken, decodeProfAspirantToken, decodeToken } from "../Utils/jwt";
import { NextFunction, Request, Response } from "express";
import { Service } from "typedi";
import AuthAdapter from '../Database/adapters/authAdapter';
import { NID_Stream } from '../types/enum';
import fsPromises from 'fs/promises';
import path from 'path';
import { v4 as uuidv4 } from 'uuid';

@Service()
export class AuthMiddleware {
  constructor(
    private readonly authAdapter: AuthAdapter
  ) {}
 
  public isProfAspirantAuthenticated = async (req: Request, res: Response, next: NextFunction) => {
    const { authorization } = req.headers;

    if (!authorization || !authorization.startsWith("Bearer")) {
      return unAuthorized(res, "Invalid token");
    }

    try {
      const token = authorization.split(" ")[1];

      const { email, stream } = decodeProfAspirantToken(token);

      const aspirant = await this.authAdapter.GetProfAspirant(email, stream);

      if (!aspirant) {
        return unAuthorized(res, "Invalid token");
      }

      req.body = {
        ...req.body,
        auth_user: {
          ...aspirant,
        }
      }
console.log(req.body.auth_user, 'authywer')
      return next();
    } catch (error) {
      return unAuthorized(res, "Invalid token");
    }
  }

  public isAspirantAuthenticatedV2 = (stream?: NID_Stream) =>  async (req: Request, res: Response, next: NextFunction) => { // called with arg (part or full)
    const { authorization } = req.headers;

    if (!authorization || !authorization.startsWith("Bearer")) {
      return unAuthorized(res, "Invalid token");
    }
  
    try {
      const token = authorization.split(" ")[1];

      const { id, stream: signedNIDStream, jamb_reg } = decodeAspirantToken(token);      
      // const { email, stream: signedProfStream } = decodeProfAspirantToken(token);

      let aspirant;
      // console.log(decodeAspirantToken(token))
      // console.log(decodeProfAspirantToken(token))

      if(stream === NID_Stream.FULL) {
        aspirant = await this.authAdapter.DBGetAspirant(id, signedNIDStream, jamb_reg);
      }
      else if(stream === NID_Stream.PART) {
        aspirant = await this.authAdapter.DBGetAspirant(id, signedNIDStream, jamb_reg);
      }
      // else if(stream !== NID_Stream.FULL && stream !== NID_Stream.PART && !jamb_reg) {
      //   aspirant = await this.authAdapter.GetProfAspirant(email, signedProfStream);
      // } 
      else {
        aspirant = await this.authAdapter.DBGetAspirant(id);
      }

      
      if (!aspirant) {
        return unAuthorized(res, "Invalid token");
      }

      req.body = {
        ...req.body,
        auth_user: {
          ...aspirant,
        }
      }

      return next();
    } catch (error) {
      return unAuthorized(res, "Invalid token");
    }
  }

  // public isNIDAspirantAuthenticated = async (req: Request, res: Response, next: NextFunction) => {
  //   const { authorization } = req.headers;

  //   if (!authorization || !authorization.startsWith("Bearer")) {
  //     return unAuthorized(res, "Invalid token");
  //   }

  //   try {
  //     const token = authorization.split(" ")[1];

  //     const { id, jamb_reg } = decodeAspirantToken(token);

  //     const aspirant = await this.authAdapter.DBGetAspirant(id, jamb_reg);

  //     if (!aspirant) {
  //       return unAuthorized(res, "Invalid token");
  //     }

  //     req.body = {
  //       ...req.body,
  //       auth_user: {
  //         ...aspirant,
  //       }
  //     }

  //     return next();
  //   } catch (error) {
  //     return unAuthorized(res, "Invalid token");
  //   }
  // }

  // public isAspirantAuthenticated = async (req: Request, res: Response, next: NextFunction) => {
  //   const { authorization } = req.headers;

  //   if (!authorization || !authorization.startsWith("Bearer")) {
  //     return unAuthorized(res, "Invalid token");
  //   }
  
  //   try {
  //     const token = authorization.split(" ")[1];

  //     const { id, jamb_reg } = decodeAspirantToken(token);
  //     const { email, stream } = decodeProfAspirantToken(token);
  //     let aspirant;
  //     // console.log(decodeAspirantToken(token))
  //     // console.log(decodeProfAspirantToken(token))
  //     if(!jamb_reg) {
  //       aspirant = await this.authAdapter.GetProfAspirant(email, stream);
  //     } else {
  //       aspirant = await this.authAdapter.DBGetAspirant(id, jamb_reg);
  //     }

  //     if (!aspirant) {
  //       return unAuthorized(res, "Invalid token");
  //     }

  //     req.body = {
  //       ...req.body,
  //       auth_user: {
  //         ...aspirant,
  //       }
  //     }

  //     return next();
  //   } catch (error) {
  //     return unAuthorized(res, "Invalid token");
  //   }
  // }

  public isStudentAuthenticated = async (req: Request, res: Response, next: NextFunction) => {
    const { authorization } = req.headers;

    if (!authorization || !authorization.startsWith("Bearer")) {
      return unAuthorized(res, "Invalid token");
    }

    
    try {
      const token = authorization.split(" ")[1];

      const { id, matric_no } = decodeToken(token);

      const student = await this.authAdapter.GetStudent(id, matric_no);

      if (!student) {
        return unAuthorized(res, "Invalid token");
      }

      req.body = {
        ...req.body,
        auth_user: {
          ...student
        }
      }

      return next();
    } catch (error) {
      return unAuthorized(res, "Invalid token");
    }
  }






  // public isAuthenticated = async (req: Request, res: Response, next: NextFunction) => {
  //   const { authorization } = req.headers;

  //   if (!authorization || !authorization.startsWith("Bearer")) {
  //     return unAuthorized(res, "Invalid token");
  //   }

    
  //   try {
  //     const token = authorization.split(" ")[1];

  //     const { id, adm_no } = decodeToken(token);

  //     const student = await this.authAdapter.GetStudent(id, adm_no);

  //     if (!student) {
  //       return unAuthorized(res, "Invalid token");
  //     }

  //     req.body = {
  //       ...req.body,
  //       auth_user: {
  //         ...student
  //       }
  //     }

  //     return next();
  //   } catch (error) {
  //     return unAuthorized(res, "Invalid token");
  //   }
  // }

  // public isStaffAuthenticated = async (req: Request, res: Response, next: NextFunction) => {
  //   const { authorization } = req.headers;

  //   if (!authorization || !authorization.startsWith("Bearer")) {
  //     return unAuthorized(res, "Invalid token");
  //   }

    
  //   try {
  //     const token = authorization.split(" ")[1];

  //     const { id, staff_no, role } = decodeStaffToken(token);

  //     const staff = await this.authAdapter.DoesStaffExist(id, staff_no);

  //     if (!staff) {
  //       return unAuthorized(res, "Invalid token");
  //     }

  //     req.body = {
  //       ...req.body,
  //       auth_user: {
  //         ...staff
  //       }
  //     }

  //     return next();
  //   } catch (error) {
  //     return unAuthorized(res, "Invalid token");
  //   }
  // }

  // public isAdmin = async (req: Request, res: Response, next: NextFunction) => {
  //   try {
  //     const { auth_user } = req.body;
  //     const { role } = auth_user;

  //     if(role !== 'admin') return unAuthorized(res, "Only Admin can access");

  //     return next()
  //   } catch (error) {
  //     return unAuthorized(res, "Only Admin can access");
  //   }
  // }
}


export const setUploadFolder = async (req: Request, res: Response, next: NextFunction) => {
  // const uniqueFolder = `${Date.now()}-${Math.random().toString(36).substr(2, 5)}`;
  const uniqueFolder = uuidv4();
  const uploadDir = path.join(process.env.UPLOAD_PATH ?? 'public/uploads', uniqueFolder);

  // Ensure the directory exists
  await fsPromises.mkdir(uploadDir, { recursive: true });

  // Attach the upload directory to req for use in multer
  req.body.uploadDir = uploadDir;

  next();
};