import { ETables } from "../../types/db.types";
import { Knex } from "knex";
import { Course_Type, Level, Semester, Stream } from "../../types/enum";

type Course = {
    code: string,
    title: string,
    description: string,
    unit: number,
    type: Course_Type,
    level: Level | null,
    semester: Semester | null,
    stream: Stream
}

const courses: Course[] = [
    {
        code: 'RTV 007',
        title: 'Basics of Radio Broadcasting',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: null,
        semester: null,
        stream: Stream.BASIC
    },
    {
        code: 'PRAD 001',
        title: 'Radio Jingle & Documentary Production',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: null,
        semester: null,
        stream: Stream.BASIC
    },
    {
        code: 'PRAD 003',
        title: 'Client Relations for Freelance Broadcasters',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: null,
        semester: null,
        stream: Stream.BASIC
    },
    {
        code: 'PRAD 005',
        title: 'Public Speaking & Event Anchoring',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: null,
        semester: null,
        stream: Stream.BASIC
    },
    {
        code: 'TNMP OO1',
        title: 'Practical Project',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: null,
        semester: null,
        stream: Stream.BASIC
    },
    {
        code: 'RTV 002',
        title: 'Creative Usage of English Language on Radio/TV',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: null,
        semester: null,
        stream: Stream.ADVANCED
    },
    {
        code: 'RTV 004',
        title: 'Creative Usage of English Language on Radio/TV',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: null,
        semester: null,
        stream: Stream.ADVANCED
    },
    {
        code: 'RTV 006',
        title: 'Advanced Broadcast Performance & Production',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: null,
        semester: null,
        stream: Stream.ADVANCED
    },
    {
        code: 'RTV 010',
        title: 'Camera Handling & TV Production',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: null,
        semester: null,
        stream: Stream.ADVANCED
    },
    {
        code: 'PRAD 002',
        title: 'Jingle & Documentary Production',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: null,
        semester: null,
        stream: Stream.ADVANCED
    },
    {
        code: 'PRAD 004',
        title: 'Client Relation for Freelance B.C ',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: null,
        semester: null,
        stream: Stream.ADVANCED
    },
    {
        code: 'PRAD 006',
        title: 'Advanced Public Speaking & Event Anchoring',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: null,
        semester: null,
        stream: Stream.ADVANCED
    },
    {
        code: 'TNMP 001',
        title: 'Practicai Project',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: null,
        semester: null,
        stream: Stream.ADVANCED
    },
    {
        code: 'GENS 101',
        title: 'English & Communication Skills',
        description: '',
        unit: 2,
        type: Course_Type.CORE,
        level: Level._100,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    {
        code: 'GENS 103',
        title: 'Citizenship Education',
        description: '',
        unit: 1,
        type: Course_Type.CORE,
        level: Level._100,
        semester: Semester.FIRST,
        stream: Stream.FULL

    },
    // {
    //     code: 'BCJ 105',
    //     title: 'Literature-in-English',
    //     description: '',
    //     unit: 2,
    //     type: Course_Type.CORE,
    //     level: Level._100,
    //     semester: Semester.FIRST,
    //     stream: Stream.FULL
    // },
    {
        code: 'BCJ 101',
        title: 'Introduction to Mass Communication',
        description: '',
        unit: 2,
        type: Course_Type.CORE,
        level: Level._100,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    {
        code: 'BCJ 105',
        title: 'News Writing I',
        description: '',
        unit: 2,
        type: Course_Type.CORE,
        level: Level._100,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    // {
    //     code: 'BCJ 107',
    //     title: 'History of Nigerian Media',
    //     description: '',
    //     unit: 2,
    //     type: Course_Type.CORE,
    //     level: Level._100,
    //     semester: Semester.FIRST,
    //     stream: Stream.FULL
    // },
    {
        code: 'BCJ 107',
        title: 'Introduction to Broadcasting ',
        description: '',
        unit: 2,
        type: Course_Type.CORE,
        level: Level._100,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    {
        code: 'BCJ 109',
        title: 'Introduction to Broadcast Sound',
        description: '',
        unit: 2,
        type: Course_Type.CORE,
        level: Level._100,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    {
        code: 'BCJ 113',
        title: 'Television Production ',
        description: '',
        unit: 2,
        type: Course_Type.COGNATE,
        level: Level._100,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    {
        code: 'BCJ 103',
        title: 'Camera and Studio Operation',
        description: '',
        unit: 2,
        type: Course_Type.COGNATE,
        level: Level._100,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    {
        code: 'BCJ 115',
        title: 'Issues in Nigeria Media',
        description: '',
        unit: 2,
        type: Course_Type.ELECTIVE,
        level: Level._100,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    // {
    //     code: 'BCJ 113',
    //     title: 'Specialized Reporting',
    //     description: '',
    //     unit: 2,
    //     type: Course_Type.CORE,
    //     level: Level._100,
    //     semester: Semester.FIRST,
    //     stream: Stream.FULL
    // },
    // {
    //     code: 'BCJ 115',
    //     title: 'Indigenous Language Broadcasting/Yoruba for Broadcasting',
    //     description: '',
    //     unit: 2,
    //     type: Course_Type.ELECTIVE,
    //     level: Level._100,
    //     semester: Semester.FIRST,
    //     stream: Stream.FULL
    // },
    {
        code: 'BCJ 117',
        title: 'Principles & Practice of Public Speaking and Event Anchoring 1',
        description: '',
        unit: 2,
        type: Course_Type.ELECTIVE,
        level: Level._100,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    // {
    //     code: 'BCJ 102',
    //     title: 'English for Broadcasting',
    //     description: '',
    //     unit: 2,
    //     type: Course_Type.CORE,
    //     level: Level._100,
    //     semester: Semester.SECOND,
    //     stream: Stream.FULL
    // },
    {
        code: 'GEN 104',
        title: 'Introduction to Political Science',
        description: '',
        unit: 1,
        type: Course_Type.CORE,
        level: Level._100,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {

        code: 'SDV 114',
        title: 'Sociology',
        description: '',
        unit: 2,
        type: Course_Type.CORE,
        level: Level._100,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'BCJ 102',
        title: 'Principles of News Writing',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: Level._100,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'BCJ 104',
        title: 'Television Broadcasting in Nigeria',
        description: '',
        unit: 2,
        type: Course_Type.CORE,
        level: Level._100,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'BCJ 106',
        title: 'Mass Communication Theories I',
        description: '',
        unit: 2,
        type: Course_Type.CORE,
        level: Level._100,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'BCJ 108',
        title: 'Script Writing I',
        description: '',
        unit: 2,
        type: Course_Type.CORE,
        level: Level._100,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'BCJ 110',
        title: 'Research Methods I',
        description: '',
        unit: 2,
        type: Course_Type.CORE,
        level: Level._100,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 112',
        title: 'Principles of Public Relations',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: Level._100,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'TVPD 103',
        title: 'Principles of Advertising',
        description: '',
        unit: 3,
        type: Course_Type.COGNATE,
        level: Level._100,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 114',
        title: 'Integrated Marketing Communication',
        description: '',
        unit: 2,
        type: Course_Type.ELECTIVE,
        level: Level._100,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 116',
        title: 'Photography and Photojournalism I',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: Level._100,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'BCJ 118',
        title: 'Principles & Practice of Public Speaking and Event Anchoring II ',
        description: '',
        unit: 2,
        type: Course_Type.ELECTIVE,
        level: Level._100,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'BCJ 120',
        title: 'Producing TV Documentary and Commercials',
        description: '',
        unit: 2,
        type: Course_Type.ELECTIVE,
        level: Level._100,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'GENS 201',
        title: 'Entrepreneurship',
        description: '',
        unit: 2,
        type: Course_Type.CORE,
        level: Level._200,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    {
        code: 'GENS 203',
        title: 'Introduction to ICT',
        description: '',
        unit: 1,
        type: Course_Type.CORE,
        level: Level._200,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 201',
        title: 'Mass Communication Theories II',
        description: '',
        unit: 2,
        type: Course_Type.CORE,
        level: Level._200,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 203',
        title: 'News Presentation',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: Level._200,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 205',
        title: 'Photography and Photojournalism II',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: Level._200,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 207',
        title: 'Investigative Journalism',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: Level._200,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 209',
        title: 'Television Directing I',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: Level._200,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    // {
    //     code: 'TVJD 203',
    //     title: 'Editing Techniques I',
    //     description: '',
    //     unit: 3,
    //     type: Course_Type.CORE,
    //     level: Level._200,
    //     semester: Semester.FIRST,
    //     stream: Stream.FULL
    // },
    {
        code: 'TVPD 205',
        title: 'Radio Production',
        description: '',
        unit: 2,
        type: Course_Type.ELECTIVE,
        level: Level._200,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 211',
        title: 'Media Law and Ethics',
        description: '',
        unit: 2,
        type: Course_Type.CORE,
        level: Level._200,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 213',
        title: 'Online Reporting',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: Level._200,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 215',
        title: 'Script Writing II',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: Level._200,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 217',
        title: 'Research Methods II',
        description: '',
        unit: 2,
        type: Course_Type.CORE,
        level: Level._200,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 219',
        title: 'Electronic Graphics',
        description: '',
        unit: 3,
        type: Course_Type.COGNATE,
        level: Level._200,
        semester: Semester.FIRST,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 202',
        title: 'Development Communication',
        description: '',
        unit: 3,
        type: Course_Type.CORE,
        level: Level._200,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 204',
        title: 'Media Management',
        description: '',
        unit: 2,
        type: Course_Type.CORE,
        level: Level._200,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 206',
        title: 'Peace and Conflict Reporting',
        description: '',
        unit: 2,
        type: Course_Type.CORE,
        level: Level._200,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 208',
        title: 'Entrepreneurship ',
        description: '',
        unit: 2,
        type: Course_Type.CORE,
        level: Level._200,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'TVPD 210',
        title: 'OB Directing',
        description: '',
        unit: 2,
        type: Course_Type.CORE,
        level: Level._200,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'TVPD 212',
        title: 'Editing Techniques II',
        description: '',
        unit: 2,
        type: Course_Type.CORE,
        level: Level._200,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 214',
        title: 'Specialized Reporting',
        description: '',
        unit: 2,
        type: Course_Type.ELECTIVE,
        level: Level._200,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 216',
        title:  'Fundamentals of Content Creation and Streaming',
        description: '',
        unit: 2,
        type: Course_Type.ELECTIVE,
        level: Level._200,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 218',
        title:  'Short Films Production Techniques',
        description: '',
        unit: 2,
        type: Course_Type.ELECTIVE,
        level: Level._200,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 220',
        title:  'Psychology of Communication',
        description: '',
        unit: 2,
        type: Course_Type.CORE,
        level: Level._200,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'TVJD 222',
        title:  'Final Year Project',
        description: '',
        unit: 4,
        type: Course_Type.CORE,
        level: Level._200,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
    {
        code: 'TVPD 224',
        title:  'Specialized Practical in Journalism',
        description: '',
        unit: 4,
        type: Course_Type.COGNATE,
        level: Level._200,
        semester: Semester.SECOND,
        stream: Stream.FULL
    },
];



export async function seed(knex: Knex): Promise<void> {

    const new_course: any[] = [];
    await Promise.all(courses.map(async course => {
        const exists = await knex.select('*').from(ETables.COURSES).where("code", course.code).first();

        if (!exists) {
            new_course.push(course);
        } else {
            console.log(`Course ${course.code} already exists in the db`);
        }

    }))

    new_course.length && await knex(ETables.COURSES).insert(new_course);

};