import { ETables } from "../../types/db.types";
import { Knex } from "knex";
import { Stream } from "../../types/enum";

type Prog = {
    name: string,
    description: string,
    duration: string,
    stream: Stream,
    open_to_application: boolean
}

const programmes: Prog[] = [
    {
        name: "NID",
        description: '',
        duration: '2 years',
        stream: Stream.FULL,
        open_to_application: true
    },
    {
        name: "NID",
        description: '',
        duration: '3 years',
        stream: Stream.PART,
        open_to_application: true
    },
    {
        name: "Professional",
        description: '',
        duration: '13 weeks',
        stream: Stream.BASIC,
        open_to_application: true
    },
    {
        name: "Professional",
        description: '',
        duration: '13 weeks',
        stream: Stream.ADVANCED,
        open_to_application: true
    }
];


export async function seed(knex: Knex): Promise<void> {
    
    const new_programme: any[] = [];
    await Promise.all(programmes.map(async prog => {
        const pg = await knex.select('*').from(ETables.PROGRAMME).where("stream", prog.stream).first();

        if(!pg) {
            new_programme.push(prog);
        } else {
            console.log(`Programme ${prog.name} already exists in the db`);
        }

    }))

    new_programme.length && await knex(ETables.PROGRAMME).insert(new_programme);

};


// export async function seed(knex: Knex): Promise<void> {
    
//     await Promise.all(programmes.map(async prog => {
//         const new_programme = [];
//         const pg = await knex.select('*').from(ETables.PROGRAMME).where("stream", prog.stream).first();

//         !pg && new_programme.push(prog);

//         if(new_programme.length) {
//             await knex(ETables.PROGRAMME).insert(new_programme);
//         } else {
//             console.log(`Programme ${prog.name} already exists in the db`);
//         }

//     }))

// };
