import { ETables } from "../../types/db.types";
import { Knex } from "knex";

type Prog = {
    name: string,
    start_date: Date,
    end_date: Date,
    is_current: boolean
}

const sessions: Prog[] = [
    {
        name: '2024/2025',
        start_date: new Date(2024, 2, 20),
        end_date: new Date(2024, 4, 20),
        is_current: true,
    }
];

const diets = [
    {
        number: 10,
        year: 2024,
        session: '2024/2025',
        is_current: true
    },
    {
        number: 11,
        year: 2024,
        session: '2024/2025',
        is_current: false
    },
    {
        number: 12,
        year: 2025,
        session: '2024/2025',
        is_current: false
    },
]


export async function seed(knex: Knex): Promise<void> {
    await knex.transaction(async trx => {
        // Insert sessions
        await insertSessionsIfNeeded(sessions, trx);

        // Insert diets after confirming session insertions
        await insertDietsIfNeeded(diets, trx);
    });
}

async function insertSessionsIfNeeded(sessions: Prog[], trx: Knex.Transaction) {
    for (const session of sessions) {
        const existingSession = await trx.select('*').from(ETables.ACADEMIC_SESSION).where("name", session.name).first();
        if (!existingSession) {
            await trx(ETables.ACADEMIC_SESSION).insert(session);
        } else {
            console.log(`Session ${session.name} already exists in the db`);
        }
    }
}

async function insertDietsIfNeeded(diets: any[], trx: Knex.Transaction) {
    for (const diet of diets) {
        const session = await trx.select('*').from(ETables.ACADEMIC_SESSION).where('name', diet.session).first();
        if (!session) {
            console.log(`Session ${diet.session} not found for diet number ${diet.number}. Skipping insertion.`);
            continue;
        }
    
        const existingDiet = await trx.select('*').from(ETables.DIET)
            .where('number', diet.number)
            .andWhere('session_id', session.id)
            .first();
    
        if (!existingDiet) {
            await trx(ETables.DIET).insert({
                number: diet.number,
                year: diet.year,
                is_current: diet.is_current,
                session_id: session.id
            });
        } else {
            console.log(`Diet ${diet.number} already exists in the database.`);
        }
    }
}


// export async function seed(knex: Knex): Promise<void> {

//     await knex.transaction(async trx => {
        
//         const new_session: any[] = [];
//         const new_diet: any[] = [];
//         await Promise.all(session.map(async sessn => {
//             const ss = await trx.select('*').from(ETables.ACADEMIC_SESSION).where("name", sessn.name).first();
        
//             if(!ss) {
//                 new_session.push(sessn);
//             } else {
//                 console.log(`Session ${sessn.name} already exists in the db`);
//             }
    
//             for(let dit of diets) {
//                 const sessioon = await trx.select('*').from(ETables.ACADEMIC_SESSION).where('name', dit.session).first();

//                 if(!sessioon) continue;
                
//                 const dd = await trx.select('*').from(ETables.DIET).where('number', dit.number).andWhere('session_id', sessioon.id).first();

//                 const { number, year, is_current } = dit

//                 if(!dd) {
//                     new_diet.push({ number, year, is_current, session_id: sessioon.id });
//                 } else {
//                     console.log(`Diet ${dit.number} already exist`)
//                 }
//             }
    
//         }))

//         new_session.length && await trx(ETables.ACADEMIC_SESSION).insert(new_session);
//         new_diet.length && await trx(ETables.DIET).insert(new_diet);
//     })

// };





// export async function seed(knex: Knex): Promise<void> {

//     await knex.transaction(async trx => {

//         await Promise.all(session.map(async sessn => {
//             const new_session = [];
//             const ss = await trx.select('*').from(ETables.ACADEMIC_SESSION).where("name", sessn.name).first();
    
//             !ss && new_session.push(sessn);
    
//             if(new_session.length) {
//                 await trx(ETables.ACADEMIC_SESSION).insert(new_session);
//             } else {
//                 console.log(`Session ${sessn.name} already exists in the db`);
//             }
    
//             const new_diet = [];
//             for(let dit of diets) {
//                 const sessioon = await trx.select('*').from(ETables.ACADEMIC_SESSION).where('name', dit.session).first();
                
//                 const dd = await trx.select('*').from(ETables.DIET).where('number', dit.number).andWhere('session_id', sessioon.id);

//                 const { number, year, is_current } = dit
//                 !dd && new_diet.push({ number, year, is_current, session_id: sessioon.id });

//                 if(new_diet.length) {
//                     await trx(ETables.DIET).insert(new_diet);
//                 } else {
//                     console.log(`Diet ${dit.number} already exist`)
//                 }
//             }
    
//         }))
//     })

// };
