import { Knex } from "knex";
import { ETables } from "../../types/db.types";
import { Gender, Status } from "../../types/enum";

export async function up(knex: Knex): Promise<void> {
    return knex.schema.alterTable(ETables.ASPIRANT, function (table) {
        table.specificType('jamb_result', 'LONGBLOB').alter();
        table.specificType('o_level', 'LONGBLOB').alter();
        table.specificType('adm_letter', 'LONGBLOB').alter();
    });
}


export async function down(knex: Knex): Promise<void> {
    return knex.schema.alterTable(ETables.ASPIRANT, function (table) {
        table.binary('adm_letter').alter();
        table.binary('o_level').alter();
        table.binary('jamb_result').alter(); 
    });
}
