import { Knex } from "knex";
import { ETables } from "../../types/db.types";
import { Stream } from "../../types/enum";

export async function up(knex: Knex): Promise<void> {
    return await knex.schema.createTable(ETables.ASSIGNED_COURSES, (table) => {
        table.increments("id", { primaryKey: true });
        table.integer("admin_id").unsigned().notNullable()
        table.foreign("admin_id").references("id").inTable(ETables.ADMIN);
        table.integer("course_id").unsigned().notNullable()
        table.foreign("course_id").references("id").inTable(ETables.COURSES);
        table.enu("stream", Object.values(Stream)).notNullable()
        table.integer("session_id").unsigned().notNullable()
        table.foreign("session_id").references("id").inTable(ETables.ACADEMIC_SESSION);
        table.timestamps(true, true);

        table.unique(["course_id", "session_id"], { indexName: "unique_course_per_session_per_admin" });
    })
}


export async function down(knex: Knex): Promise<void> {
    return await knex.schema.dropTable(ETables.ASSIGNED_COURSES);
}
