import { Knex } from "knex";
import { ETables } from "../../types/db.types";
import { COD } from "../../types/enum";

export async function up(knex: Knex): Promise<void> {
    return await knex.schema.createTable(ETables.GRADE, (table) => {
        table.increments('id').primary();
        table.integer('mark_min').notNullable();
        table.integer('mark_max').notNullable();
        table.string('letter_grade', 2).notNullable();
        table.decimal('weight', 3, 2).notNullable();
    })
    .createTable(ETables.CGPA_GRADE, table => {
        table.increments('id').primary();
        table.decimal('mark_min', 3, 2).notNullable();
        table.decimal('mark_max', 3, 2).notNullable();
        table.enum('class', Object.values(COD)).notNullable();
    })
}


export async function down(knex: Knex): Promise<void> {
    return await knex.schema.dropTable(ETables.CGPA_GRADE)
    .dropTable(ETables.GRADE);
}
