import { Knex } from "knex";
import { ETables } from "../../types/db.types";
import { Level } from "../../types/enum";

export async function up(knex: Knex): Promise<void> {
    return await knex.schema.createTable(ETables.COURSE_REG, (table) => {
        table.increments("id", { primaryKey: true });
        table.float('grade').notNullable().defaultTo(0.00);
        table.float('CA').notNullable().defaultTo(0.00);
        table.float('exam').notNullable().defaultTo(0.00);
        table.enum('current_level', Object.values(Level)).notNullable();  //student level itself
        table.integer("student_id").unsigned()
        table.foreign("student_id").references("id").inTable(ETables.STUDENT);
        table.integer("course_id").unsigned()
        table.foreign("course_id").references("id").inTable(ETables.COURSES);
        // table.boolean('result_uploaded').notNullable().defaultTo(false);
        table.integer("session_id").unsigned()
        table.foreign("session_id").references("id").inTable(ETables.ACADEMIC_SESSION);
        table.timestamps(true, true);

        table.unique(["student_id", "course_id", "session_id"], { indexName: "unique_course_per_session" });
    })
}


export async function down(knex: Knex): Promise<void> {
    return await knex.schema.dropTable(ETables.COURSE_REG);
}
