import { Knex } from "knex";
import { ETables } from "../../types/db.types";
import { Level, Stream, Semester, Course_Type } from "../../types/enum";

export async function up(knex: Knex): Promise<void> {
    return await knex.schema.createTable(ETables.COURSES, (table) => {
        table.increments("id", { primaryKey: true });
        table.string("code").notNullable().unique();
        table.string("title", 255).notNullable();
        table.text("description", "longtext").notNullable();
        table.integer("unit").unsigned().notNullable();
        table.enum("type", Object.values(Course_Type)).defaultTo(Course_Type.CORE)
        table.enu('level', Object.values(Level))  // the level of teh course opriginally
        table.enu('semester', Object.values(Semester))
        table.enum("stream", Object.values(Stream)).notNullable()
        table.timestamp("deleted_at");
        table.timestamps(true, true);
    })
    // .raw(`
    //     ALTER TABLE ${ETables.COURSES} 
    //     ADD CONSTRAINT CHECK_stream_semester 
    //     CHECK ((stream IN ('basic', 'advanced') AND semester IS NULL) OR (stream = 'standard' AND semester IS NOT NULL))
    // `)
    // .raw(`
    //     ALTER TABLE ${ETables.COURSES} 
    //     ADD CONSTRAINT CHECK_stream_level 
    //     CHECK ((stream IN ('basic', 'advanced') AND level IS NULL) OR (stream = 'standard' AND level IS NOT NULL))
    // `)
}


export async function down(knex: Knex): Promise<void> {
    return await knex.schema.dropTable(ETables.COURSES);
}
