import { Knex } from "knex";
import { ETables } from "../../types/db.types";

export async function up(knex: Knex): Promise<void> {
    return await knex.schema.createTable(ETables.PAY_REF, (table) => {
        table.increments("id", { primaryKey: true });
        table.string('reference').notNullable().unique();
        table.string('email').notNullable();
        table.json('description').notNullable();
        table.timestamps(true, true);
    });
}

export async function down(knex: Knex): Promise<void> {
    return await knex.schema.dropTable(ETables.PAY_REF);
}
