import { Knex } from "knex";
import { ETables } from "../../types/db.types";
import { Gender, Level, Status, Stream } from "../../types/enum";

export async function up(knex: Knex): Promise<void> {
    return await knex.schema.createTable(ETables.STUDENT, (table) => {
        table.increments("id", { primaryKey: true });
        table.string("first_name", 255).notNullable();
        table.string("last_name", 255).notNullable();
        table.string("middle_name", 255);
        table.string("email").unique().notNullable();
        table.string("phone").notNullable();
        table.date('DOB').notNullable();
        table.enum("gender", Object.values(Gender)).notNullable()
        table.string('adm_no').notNullable();
        table.string('matric_no').notNullable();
        table.string("password").notNullable();
        table.float("GP").unsigned().notNullable().defaultTo(0.00);
        table.float("CGP").unsigned().notNullable().defaultTo(0.00);
        table.enum("level", Object.values(Level)).notNullable();
        
        table.enu('stream', Object.values(Stream)).notNullable();
        table.boolean('paid').notNullable().defaultTo(false);
        table.enum("status", Object.values(Status)).notNullable().defaultTo(Status.PENDING);
        table.timestamps(true, true);

    })
}


export async function down(knex: Knex): Promise<void> {
    return await knex.schema.dropTable(ETables.STUDENT);
}
