import { Knex } from "knex";
import { ETables } from "../../types/db.types";
import { Category, Gender, Status } from "../../types/enum";

export async function up(knex: Knex): Promise<void> {
    return await knex.schema.createTable(ETables.PROF_ASPIRANT, (table) => {
        table.increments("id", { primaryKey: true });
        table.string("first_name", 255).notNullable();
        table.string("last_name", 255).notNullable();
        table.string("middle_name", 255);
        table.string("email").unique().notNullable();
        table.string("password");
        table.date('DOB');
        table.enum("gender", Object.values(Gender)).notNullable()
        table.string("phone").notNullable();
        table.string("qualification");
        table.string("workplace");
        table.integer('years_of_exp');
        table.binary("certificate");
        table.string('mimetype');
        table.boolean('paid').notNullable().defaultTo(false);
        // table.enum("status", Object.values(Status)).notNullable().defaultTo(Status.PENDING);
        table.enum("status", Object.values(Status))
        table.specificType("passport", 'LONGBLOB').notNullable();
        table.string('passport_mimetype');
        table.integer("diet_id").unsigned();
        table.foreign("diet_id").references("id").inTable(ETables.DIET);
        table.integer("programme_id").unsigned()
        table.foreign("programme_id").references("id").inTable(ETables.PROGRAMME);
        table.integer("session_id").unsigned()
        table.foreign("session_id").references("id").inTable(ETables.ACADEMIC_SESSION);
        table.timestamps(true, true);

    })
}


export async function down(knex: Knex): Promise<void> {
    return await knex.schema.dropTable(ETables.PROF_ASPIRANT);
}
