import { Knex } from "knex";
import { ETables } from "../../types/db.types";
import { Category } from "../../types/enum";

export async function up(knex: Knex): Promise<void> {
    return await knex.schema.createTable(ETables.FEE, (table) => {
        table.increments("id", { primaryKey: true });
        table.string("name", 255).notNullable();
        table.string("description", 255);
        table.decimal('amount', 14, 2).notNullable();
        table.boolean('is_recurrent').notNullable();
        table.boolean('upfront').notNullable();
        table.enum("category", Object.values(Category)).notNullable();
        // table.integer("programme_id").unsigned()
        // table.foreign("programme_id").references("id").inTable(ETables.PROGRAMME);
        table.integer("session_id").unsigned()
        table.foreign("session_id").references("id").inTable(ETables.ACADEMIC_SESSION);
        table.timestamps(true, true);

        table.unique(["name", "session_id", "category"], { indexName: "unique_fee_category_session" });
    })
}


export async function down(knex: Knex): Promise<void> {
    return await knex.schema.dropTable(ETables.FEE);
}
