import { Knex } from "knex";
import { ETables } from "../../types/db.types";
import { Semester } from "../../types/enum";

export async function up(knex: Knex): Promise<void> {
    return await knex.schema.createTable(ETables.ACADEMIC_SESSION, (table) => {
        table.increments("id", { primaryKey: true });
        table.string("name", 255).notNullable().unique();
        table.date("start_date").notNullable();
        table.date("end_date").notNullable();
        table.boolean("is_current").notNullable().defaultTo(false);
        table.enu('current_semester', Object.values(Semester))
        table.timestamps(true, true);
    })
}


export async function down(knex: Knex): Promise<void> {
    return await knex.schema.dropTable(ETables.ACADEMIC_SESSION);
}
