// import { DB_HOST, DB_NAME, DB_PASS, DB_PORT, DB_URL, DB_USER } from '@/Config';
// import { logger } from '@/Logger';
import { knex as knexObject } from 'knex';

const knexConfig = {
  client: 'mysql2',
  connection: process.env.DATABASE_URL,
  pool: {
    min: 2,
    max: 10
  },
  timezone: 'UTC'
}

const knex = knexObject(knexConfig);


export class BaseAdapter {
  public catchError = (error: any) => {
    // logger.error(error);
    console.error(error)
    throw new Error("Failed at db level")
  }
}

export default knex;