import { Service } from "typedi";
import knex, { BaseAdapter } from ".";
import { ETables } from "../../types/db.types";
import { Category, Level, Semester, Stream, Course_Type, NID_Stream, Fee_Type } from "../../types/enum";

@Service()
class FeeAdapter extends BaseAdapter {
    constructor() {
        super()
    }

    public DBCreateAspirantFee = async (id: number, fee: any, amount_paid: number, stream: Stream, reference: string, session: any) => {
        try {
            // stream = !stream ? Stream.STANDARD : stream
            const obj = {
                amount_paid,
                amount_due: fee.amount,
                stream,
                year: new Date().getFullYear(),
                completed: amount_paid == fee.amount,
                balance: fee.amount - amount_paid,
                reference,
                diet_id: session.current_diet.id,
                fee_id: fee.id,
                // prof_aspirant_id: stream !== Stream.STANDARD ? id : null,
                prof_aspirant_id: !(Object.values(NID_Stream  as any).includes(stream)) ? id : null,
                // aspirant_id: stream === Stream.STANDARD ? id : null,
                aspirant_id: Object.values(NID_Stream  as any).includes(stream) ? id : null,
                // programme_id,
                session_id: session.id
            }
            await knex.select('*').from(ETables.ASPIRANT_FEE).insert(obj);
        } catch (error) {
            return this.catchError(error);
        }
    }

    public DBCreateStudentFee = async (student_id: number, fee: any, amount_paid: number, stream: Stream, reference: string, programme_id: number, session: any, residual: boolean) => {
        try {
            const records = await knex.select('*').from(ETables.STUDENT_FEE).where('student_id', student_id).andWhere('session_id', session.id);
            console.log(fee, 'fee')
            console.log(records, 'records')
            if (residual) {
                // for(let record of records) {
                //     if(record.id === fee.id)
                // }
                const found = records.find(record => record.fee_id === Number(fee.id));
                console.log(found, 'almost');
                
                const total_amount_paid = Number(found.amount_paid) + Number(amount_paid)
                await knex(ETables.STUDENT_FEE).update({
                    amount_paid: total_amount_paid,
                    balance: found.amount_due - total_amount_paid,
                    completed: found.amount_due == total_amount_paid
                }).where('fee_id', fee.id);

                return;
            }
            
            const obj = {
                amount_paid,
                amount_due: fee.amount,
                stream,
                year: new Date().getFullYear(),
                completed: amount_paid == fee.amount,
                balance: fee.amount - amount_paid,
                reference,
                diet_id: session?.current_diet?.id,
                // diet_id: stream == Stream.STANDARD ? null : session?.current_diet?.id,
                fee_id: fee.id,
                student_id,
                programme_id,
                session_id: session.id
            }
            await knex(ETables.STUDENT_FEE).insert(obj);
        } catch (error) {
            return this.catchError(error);
        }
    }

    public DBGetProfFormFee = async (session_id: number) => {
        try {
            const fee = await knex.select('*').from(ETables.FEE).where("name", Fee_Type.FORM).andWhere("category", Category.PROFESSIONAL).andWhere("session_id", session_id).first();
            fee.amount = Number(fee.amount);

            return fee;
        } catch (error) {
            return this.catchError(error);
        }
    }

    // NID

    public DBGetPUTMFee = async (session_id: number) => {
        try {
            const fee = await knex.select('*').from(ETables.FEE).where('name', Fee_Type.PUTME).andWhere("session_id", session_id).first();
            fee.amount = Number(fee.amount);

            return fee;
        } catch (error) {
            return this.catchError(error);
        }
    }

    public DBGetPartApplicationFee = async (session_id: number) => {
        try {
            const fee = await knex.select('*').from(ETables.FEE).where('name', Fee_Type.PART_FORM).andWhere("session_id", session_id).first();
            fee.amount = Number(fee.amount);

            return fee;
        } catch (error) {
            return this.catchError(error);
        }
    }

    public DBGetSchoolFee = async (category: Stream, session_id: number) => {
        try {
            const fee = await knex.select('*').from(ETables.FEE).where('name', Fee_Type.TUITION).andWhere('category', category).andWhere("session_id", session_id).first();
            fee.amount = Number(fee.amount);

            return fee;
        } catch (error) {
            return this.catchError(error);
        }
    }

    // BOTH

    public DBGetIDCardFee = async (session_id: number, category: Category) => {
        try {
            const fee = await knex.select('*').from(ETables.FEE).where("name", Fee_Type.ID_CARD).andWhere("category", category).andWhere("session_id", session_id).first();
            fee.amount = Number(fee.amount);
console.log(fee, 'IDCARDDDDD')
            return fee;
        } catch (error) {
            return this.catchError(error);
        }
    }

    public DBGetAcceptanceFee = async (session_id: number, category: Category) => {
        try {
            const fee = await knex.select('*').from(ETables.FEE).where("name", Fee_Type.ACCEPTANCE).andWhere("category", category).andWhere("session_id", session_id).first();
            fee.amount = Number(fee.amount);

            return fee;
        } catch (error) {
            return this.catchError(error);
        }
    }

    // STUDENTTTTTTTT

    public DBGetOutstandingFee = async (user_id: number, session_id: number, stream: Stream, residual: boolean) => {
        try {
            console.log(residual, 'outstandingggg')
            let fees: any[] = [];

            let fees_to_balance: { fee_id: number, balance: number }[] = [];
            const paid_fees = await knex.select('*').from(ETables.STUDENT_FEE).where('student_id', user_id).andWhere('session_id', session_id);
            // const paid_fees = await knex.select('*').from(ETables.ASPIRANT_FEE).where('prof_aspirant_id', 1).andWhere('session_id', session_id);
// console.log(paid_fees, 'paid_fees')

            // if not paid fees, that means it's a new session and the student is returning
            // if (!paid_fees && stream == 'standard') {
            if (!paid_fees && Object.values(NID_Stream as any).includes(stream)) {
                const fees = await knex.select('*').from(ETables.FEE).where('category', stream);
                console.log('It is a new a session');

                return fees
            }

            for (let fee of paid_fees) {
                if (fee.completed) continue
                fees_to_balance.push({
                    fee_id: fee.fee_id,
                    balance: Number(fee.balance)
                });
            };
// console.log(fees_to_balance, 'fees_to_balance')
            if (!fees_to_balance.length) return fees;

            const outstanding = await knex.select('*').from(ETables.FEE).whereIn('id', fees_to_balance.map(fee => fee.fee_id));
// console.log(outstanding, 'outstanding')
            // process it and get the balnce and push oit to fees above but for ---------  later
            for (let fee of outstanding) {
                for (let bal of fees_to_balance) {
                    if (bal.fee_id === fee.id && bal.balance) {
                        fee.amount = Number(bal.balance);
                        fee.upfront = false;
                        residual
                    }
                }
            }

            return outstanding;
        } catch (error) {
            return this.catchError(error);
        }
    }










    // TEST

    public DBTest = async () => {
        try {
            const fees = await knex.select('*').from(ETables.FEE);

            return fees;
        } catch (error) {
            return this.catchError(error);
        }
    }
}

@Service()
export class FeeValidatorAdapter extends BaseAdapter {
    constructor() {
        super()
    }

    public DBDoesProgrammeExist = async (id: number) => {
        try {
            const programme = await knex.select('*').from(ETables.PROGRAMME).where("id", id).first();

            return programme;
        } catch (error) {
            return this.catchError(error);
        }
    }

    public DBIsProgrammeOpenToAdmission = async (stream: Stream) => {
        try {
            const open = await knex.select('*').from(ETables.PROGRAMME).where('stream', stream).andWhere('open_to_application', true).first();

            return !!open
        } catch (error) {
            return this.catchError(error);
        }
    }

    public DBFeeExist = async (id: number) => {
        try {
            const fee = await knex.select('*').from(ETables.FEE).where('id', id).first();

            return !!fee
        } catch (error) {
            return this.catchError(error);
        }
    }

    public DBIsFeeSplittable = async (name: string, category: Category) => {
        try {
            const splittable = await knex.select('*').from(ETables.FEE).where('name', name).andWhere('category', category).andWhere('upfront', true).first();

            return !!splittable
        } catch (error) {
            return this.catchError(error);
        }
    }

    public DBGetFeeByNameAndCategory = async (name: string, category: Category) => {
        try {
            const fee = await knex.select('*').from(ETables.FEE).where('name', name).andWhere('category', category).first();

            return fee;
        } catch (error) {
            return this.catchError(error);
        }
    }

    public DBHasPaidFee = async (fee_id: number, user_id: number) => {
        try {
            const paid = await knex.select('*').from(ETables.ASPIRANT_FEE).where({ fee_id, prof_aspirant_id: user_id }).first();

            return !!paid
        } catch (error) {
            return this.catchError(error);
        }
    }

    public DBCheckOutstandingFee = async (user_id: number, session_id: number, stream: Stream, residual: boolean) => {
        try {
            let fees: any[] = [];

            let fees_to_balance: { fee_id: number, balance: number }[] = [];
            const paid_fees = await knex.select('*').from(ETables.STUDENT_FEE).where('student_id', user_id).andWhere('session_id', session_id);
            
            // if (!paid_fees && stream == 'standard') {
                if (!paid_fees && Object.values(NID_Stream as any).includes(stream)) {
                const fees = await knex.select('*').from(ETables.FEE).where('category', stream);
                console.log('It is a new a session');

                return !!fees.length
            }

            for (let fee of paid_fees) {
                if (fee.completed) continue
                fees_to_balance.push({
                    fee_id: fee.fee_id,
                    balance: Number(fee.balance)
                });
            };

            if (!fees_to_balance.length) return !!fees.length;

            const outstanding = await knex.select('*').from(ETables.FEE).whereIn('id', fees_to_balance.map(fee => fee.fee_id));

            for (let fee of outstanding) {
                for (let bal of fees_to_balance) {
                    if (bal.fee_id === fee.id && bal.balance) {
                        fee.amount = Number(bal.balance);
                        fee.upfront = false;
                        residual
                    }
                }
            }
            console.log(outstanding, 'oout')

            return !!outstanding.length;
        } catch (error) {
            return this.catchError(error);
        }
    }

}

export default FeeAdapter;