"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const typedi_1 = require("typedi");
const __1 = tslib_1.__importDefault(require(".."));
const bcrypt = tslib_1.__importStar(require("bcryptjs"));
const adminAdapter_1 = require("../../Database/adapters/adminAdapter");
const courseAdapter_1 = require("../../Database/adapters/courseAdapter");
const enum_1 = require("../../types/enum");
const aspirantAdapter_1 = require("../../Database/adapters/aspirantAdapter");
let AdminValidator = class AdminValidator extends __1.default {
    constructor(adminValAdapter, courseValAdapter, aspirantValAdapter) {
        super();
        this.adminValAdapter = adminValAdapter;
        this.courseValAdapter = courseValAdapter;
        this.aspirantValAdapter = aspirantValAdapter;
        this.loginValidator = this.validate({
            email: {
                in: ["body"],
                isEmail: true,
                toLowerCase: true,
            },
            password: {
                in: ["body"],
                isString: true,
                isLength: { options: { min: 8 } },
                custom: {
                    options: (password, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        console.log('hERE');
                        const user = yield this.adminValAdapter.DBGetUserAndPassword(req.body.email);
                        if (!user || !bcrypt.compareSync(password, user.password)) {
                            throw new Error("Invalid credentials!");
                        }
                        req.body.id = user.id;
                        req.body.role = user.role;
                    })
                },
                errorMessage: 'Invalid credentials'
            }
        });
        this.validateEditAdmin = this.validate({
            id: {
                in: ['params'],
                isInt: true,
                custom: {
                    options: (id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const valid = yield this.adminValAdapter.DBGetAdmin(id);
                        if (!valid)
                            throw new Error("Admin doesn't exist");
                    })
                }
            },
            role_id: {
                in: ['body'],
                isInt: true,
                optional: true,
                custom: {
                    options: (role_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const valid = yield this.adminValAdapter.checkForValidRole(role_id);
                        if (!valid)
                            throw new Error('Invalid role');
                    })
                }
            },
            name: {
                in: ['body'],
                isString: true,
                optional: true
            },
            email: {
                in: ['body'],
                isEmail: true,
                optional: true,
                custom: {
                    options: (email, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        var _a, _b;
                        const exists = yield this.adminValAdapter.DBGetUserAndPassword(email);
                        console.log(((_a = req.params) === null || _a === void 0 ? void 0 : _a.id) !== exists.id);
                        if (+((_b = req.params) === null || _b === void 0 ? void 0 : _b.id) !== exists.id && exists)
                            throw new Error('Admin already exists');
                    })
                }
            }
        });
        this.validateGetProgrammeByCategory = this.validate({
            prog_level: {
                in: ['params'],
                isString: true,
                isIn: { options: [Object.values(enum_1.Stream)] },
                custom: {
                    options: (prog_level) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const exist = yield this.adminValAdapter.checkProgramByCategory(prog_level);
                        if (!exist)
                            throw new Error('Invalid programme');
                    })
                }
            }
        });
        this.validateGetCourses = this.validate({
            stream: {
                in: ['params'],
                isString: true,
                isIn: { options: [Object.values(enum_1.Stream)] }
            }
        });
        this.validateGetACourse = this.validate({
            stream: {
                in: ['params'],
                isString: true,
                isIn: { options: [Object.values(enum_1.Stream)] }
            },
            id: {
                in: 'params',
                isInt: true,
                custom: {
                    options: (id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const exist = yield this.courseValAdapter.DBGetCourseById(id);
                        if (!exist)
                            throw new Error('Invalid course');
                    })
                }
            }
        });
        this.validateAssignStaff = this.validate({
            stream: {
                in: ['params'],
                isString: true,
                isIn: { options: [Object.values(enum_1.Stream)] }
            },
            id: {
                in: 'params',
                isInt: true,
                custom: {
                    options: (id, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const exist = yield this.courseValAdapter.DBCourseAlreadyAssignedForTheSession(id, req.body.session.id);
                        if (exist)
                            throw new Error('Course already asigned for the selected session');
                    })
                }
            },
            admin_ids: {
                in: 'body',
                isArray: true,
                isInt: true,
                custom: {
                    options: (admin_ids) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        if (new Set(admin_ids).size !== admin_ids.length)
                            throw new Error('Duplicate id found');
                        for (let admin_id of admin_ids) {
                            const exists = yield this.adminValAdapter.DBGetAdmin(admin_id);
                            if (!exists)
                                throw new Error('Invalid admin');
                        }
                    })
                }
            }
        });
        this.validateGetAssignedStaff = this.validate({
            stream: {
                in: ['params'],
                isString: true,
                isIn: { options: [Object.values(enum_1.Stream)] }
            },
            id: {
                in: 'params',
                isInt: true,
                custom: {
                    options: (id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const exist = yield this.courseValAdapter.DBGetCourseById(id);
                        if (!exist)
                            throw new Error('Invalid course');
                    })
                }
            }
        });
        this.validateGetApplications = this.validate({
            stream: {
                in: ['params'],
                isString: true,
                isIn: { options: [Object.values(enum_1.Stream)] },
                custom: {
                    options: (stream) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const valid = yield this.adminValAdapter.CheckProgrammeByStream(stream);
                        if (!valid)
                            throw new Error('Invalid programme');
                    })
                }
            }
        });
        this.validateGetAnApplication = this.validate({
            stream: {
                in: ['params'],
                isString: true,
                isIn: { options: [Object.values(enum_1.Stream)] }
            },
            id: {
                in: ['params'],
                isInt: true,
                custom: {
                    options: (id, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        var _c;
                        const valid = yield this.adminValAdapter.DBCheckApplication(id, (_c = req.params) === null || _c === void 0 ? void 0 : _c.stream);
                        if (!valid)
                            throw new Error('Applicannt does not exist');
                    })
                }
            }
        });
        this.validateApplicationReview = this.validate({
            id: {
                in: ['params'],
                isInt: true,
                custom: {
                    options: (id, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        var _d;
                        const valid = yield this.adminValAdapter.DBCheckApplication(id, (_d = req.params) === null || _d === void 0 ? void 0 : _d.stream);
                        if (!valid)
                            throw new Error('Application does not exist');
                    })
                }
            },
            status: {
                in: ['body'],
                isIn: { options: ['accepted', 'rejected'] }
            },
            stream: {
                in: 'params',
                isIn: { options: [Object.values(enum_1.Stream)] },
                custom: {
                    options: (stream, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const valid = yield this.adminValAdapter.CheckProgrammeByStream(stream);
                        if (!valid)
                            throw new Error('Invalid programme');
                        req.body.programme_id = valid.id;
                    })
                }
            },
            comment: {
                in: ['body'],
                isString: true
            }
        });
        this.validateGetCourseResult = this.validate({
            id: {
                in: 'params',
                isInt: true,
                custom: {
                    options: (id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const exist = yield this.courseValAdapter.DBGetCourseById(id);
                        if (!exist)
                            throw new Error('Invalid course');
                    })
                }
            },
            session_id: {
                in: ['params'],
                isInt: true,
                custom: {
                    options: (session_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const valid = this.adminValAdapter.IsAValidSession(session_id);
                        if (!valid)
                            throw new Error('Invalid session');
                    })
                }
            }
        });
        this.validateDownloadFile = this.validate({
            file_path: {
                in: 'params',
                isString: true,
                custom: {
                    options: (file_path) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        if (file_path === null || file_path === undefined || file_path === 'null')
                            throw new Error('Invalid file');
                    })
                }
            }
        });
        this.validateSetFee = this.validate({
            name: {
                in: ['body'],
                isString: true
            },
            amount: {
                in: ['body'],
                isFloat: true
            },
            prog_level: {
                in: ["body"],
                isString: true,
                isIn: { options: [Object.values(enum_1.Stream)] },
                optional: true
            },
            programme_id: {
                in: ['body'],
                isInt: true,
                optional: true,
                custom: {
                    options: (programme_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const programme_exist = yield this.adminValAdapter.DoesProgrammeExist(programme_id);
                        if (!programme_exist)
                            throw new Error('');
                    })
                }
            },
            session_id: {
                in: ['body'],
                isInt: true,
                custom: {
                    options: (session_id, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const isValid = yield this.adminValAdapter.IsAValidSession(session_id);
                        if (!isValid)
                            throw new Error('Invalid session provided');
                        req.body = Object.assign(Object.assign({}, req.body), { session: isValid.name });
                    })
                }
            },
            category: {
                in: ['body'],
                isString: true,
                isIn: { options: [Object.values(enum_1.Category)] }
            },
            is_recurrent: {
                in: ['body'],
                isBoolean: true,
            }
        });
        this.validateCreateCourse = this.validate({
            title: {
                in: ["body"],
                isString: true,
                notEmpty: true,
                custom: {
                    options: (title) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        // const exists = await this.courseValAdapter.DBDoesCourseTitleExist(title);
                        // if (exists) throw new Error('Title already exist');
                    })
                }
            },
            code: {
                in: ["body"],
                isString: true,
                isLength: { options: { min: 6 } },
                custom: {
                    options: (code) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        // const exists = await this.courseValAdapter.DBDoesCourseCodeExist(code);
                        // if (exists) throw new Error('Duplicate course code');
                    })
                }
            },
            description: {
                in: ["body"],
                isString: true,
                notEmpty: true,
            },
            unit: {
                in: ["body"],
                isInt: true,
            },
            type: {
                in: ["body"],
                isString: true,
                isIn: { options: [Object.values(enum_1.Course_Type)] },
            },
            prog_level: {
                in: ["body"],
                isString: true,
                isIn: { options: [Object.values(enum_1.Stream)] },
            },
        });
        this.validateUploadAspirant = this.validate({
            sheetName: {
                in: ['body'],
                isString: true,
                custom: {
                    options: (sheetName, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        if (!req.file)
                            throw new Error('No file uploaded');
                        return true;
                    })
                }
            },
            session_id: {
                in: ['body'],
                isInt: true,
                custom: {
                    options: (session_id, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const isValid = yield this.adminValAdapter.IsAValidSession(session_id);
                        if (!isValid)
                            throw new Error('Invalid session provided');
                        req.body = Object.assign(Object.assign({}, req.body), { session: isValid.name });
                    })
                }
            },
            year: {
                in: ['body'],
                isInt: true
            },
        });
        this.validateViewAnAspirant = this.validate({
            jamb_reg: {
                in: ['params'],
                isString: true,
                custom: {
                    options: (jamb_reg) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        // const exist = await this.aspirantValAdapter.DBGetAspirant(jamb_reg)
                        // if (!exist) throw new Error('Aspirant does not exist');
                    })
                }
            }
        });
        this.validatePutmeResultUpload = this.validate({
            type: {
                in: 'body',
                isString: true,
            },
            session_id: {
                in: ['body'],
                isInt: true,
                custom: {
                    options: (session_id, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const isValid = yield this.adminValAdapter.IsAValidSession(session_id);
                        if (!isValid)
                            throw new Error('Invalid session provided');
                        req.body = Object.assign(Object.assign({}, req.body), { session: isValid.name });
                    })
                }
            },
            year: {
                in: ['body'],
                isInt: true
            },
            sheetName: {
                in: ['body'],
                isString: true,
                custom: {
                    options: (sheetName, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        if (!req.file)
                            throw new Error('No file uploaded');
                        return true;
                    })
                }
            }
        });
        this.validateAspirantsStatus = this.validate({
            status: {
                in: ['query'],
                isString: true,
                isIn: { options: [Object.values(enum_1.Status)] }
            },
            jamb_regs: {
                in: ['body'],
                isArray: { options: { min: 1 } },
                notEmpty: true,
                // isString: true,
                custom: {
                    options: (jamb_regs, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        if (new Set(jamb_regs).size !== jamb_regs.length)
                            throw new Error('The courses must be unique');
                        for (let reg of jamb_regs) {
                            // const exist = await this.aspirantValAdapter.DBGetAspirant(reg);
                            // if (!exist) throw new Error('Aspirant does not exist');
                            // if (!exist.grade) throw new Error(`One of the aspirant doesn't have a grade`);
                        }
                    })
                }
            }
        });
        this.validateGetStudents = this.validate({
            programme_id: {
                in: ['params'],
                isInt: true,
                custom: {
                    options: (programme_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const exist = yield this.adminValAdapter.DoesProgrammeExist(programme_id);
                        if (!exist)
                            throw new Error('Invalid programme');
                    })
                }
            }
        });
    }
};
AdminValidator = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [adminAdapter_1.AdminValidatorAdapter,
        courseAdapter_1.CourseValidatorAdapter,
        aspirantAdapter_1.AspirantValidatorAdapter])
], AdminValidator);
exports.default = AdminValidator;
