"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendSMS = void 0;
const tslib_1 = require("tslib");
const twilio_1 = tslib_1.__importDefault(require("twilio"));
const accountSid = process.env.TWILIO_ACCOUNT_SID;
const authToken = process.env.TWILIO_AUTH_TOKEN;
const client = (0, twilio_1.default)(accountSid, authToken);
const sendSMS = (recipient, msg) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    try {
        const message = yield client.messages.create({
            body: msg,
            messagingServiceSid: 'MGXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
            to: recipient
        });
        if (!message)
            throw new Error('Failed to send sms');
        console.log(message, 'successssssss');
    }
    catch (error) {
        console.log('Errorror', error);
    }
});
exports.sendSMS = sendSMS;
// client.messages
//   .create({
//     body: 'You have an appointment with Owl, Inc. on Friday, November 3 at 4:00 PM. Reply C to confirm.',
//     messagingServiceSid: 'MGXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
//     to: '+15558675310'
//   })
//   .then(message => console.log(message.sid));
