"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const typedi_1 = require("typedi");
const axios_1 = tslib_1.__importDefault(require("axios"));
let Paystack = class Paystack {
    constructor() {
        this.instantiateApi = () => {
            this.api = axios_1.default.create({
                baseURL: this.url,
                headers: {
                    "Content-Type": "application/json",
                    Authorization: `Bearer ${this.token}`
                }
            });
        };
        this.initializeTransaction = this.asyncWrapper((data) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            return yield this.api.post("/transaction/initialize", data);
        }));
        this.verifyTransaction = this.asyncWrapper((reference) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            return yield this.api.get(`/transaction/verify/${reference}`);
        }));
        this.token = `${process.env.PAYSTACK_SECRET_KEY}`;
        this.url = process.env.PAYSTACK_BASEURL;
        this.instantiateApi();
    }
    asyncWrapper(fn) {
        return (arg) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const res = yield fn(arg);
                if (res.status) {
                    return res.data.data;
                }
                throw new Error(res.data);
            }
            catch (error) {
                console.log(error);
                throw error;
            }
        });
    }
};
Paystack = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [])
], Paystack);
exports.default = Paystack;
