"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const typedi_1 = require("typedi");
const axios_1 = tslib_1.__importDefault(require("axios"));
// import { PAYPAL_CLIENT_ID, PAYPAL_SECRET , PAYPAL_ACCESS_TOKEN} from "../../Config";
const { PAYPAL_CLIENT_ID, PAYPAL_SECRET, PAYPAL_ACCESS_TOKEN } = process.env;
let Paypal = class Paypal {
    constructor() {
        this.instantiateApi = () => tslib_1.__awaiter(this, void 0, void 0, function* () {
            this.api = axios_1.default.create({
                baseURL: this.url,
                headers: {
                    "Content-Type": "application/json",
                    // Authorization: `Bearer ${await this.generateAccessToken()}`
                    Authorization: `Bearer ${PAYPAL_ACCESS_TOKEN}`
                }
            });
            console.log(yield this.generateAccessToken());
        });
        this.generateAccessToken = () => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                if (!PAYPAL_CLIENT_ID || !PAYPAL_SECRET) {
                    throw new Error("MISSING_API_CREDENTIALS");
                }
                const auth = Buffer.from(PAYPAL_CLIENT_ID + ":" + PAYPAL_SECRET).toString("base64");
                const response = yield fetch(`${this.url}/v1/oauth2/token`, {
                    method: "POST",
                    body: "grant_type=client_credentials",
                    headers: {
                        Authorization: `Basic ${auth}`,
                    },
                });
                const data = yield response.json();
                console.log(data.access_token, 'accessToken');
                return data.access_token;
            }
            catch (error) {
                throw error;
            }
        });
        this.createOrder = (cart) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            // use the cart information passed from the front-end to calculate the purchase unit details
            console.log("shopping cart information passed from the frontend createOrder() callback:", cart);
            // const accessToken = await this.generateAccessToken();
            // const url = `${base}/v2/checkout/orders`;
            const payload = {
                intent: "CAPTURE",
                purchase_units: [
                    // {
                    //   amount: {
                    //     currency_code: "USD",
                    //     value: cart.price,
                    //   },
                    //   ...cart
                    // },
                    {
                        "amount": {
                            "currency_code": "USD",
                            "value": "100.00"
                        }
                    }
                ],
                "name": "examples.link",
                "premium": true,
                "purchaseType": "registration",
                "renewalPrice": 125,
                "available": true
            };
            // return await this.api.post(`/v2/checkout/orders`, payload);
            const response = yield fetch(`${this.url}/v2/checkout/orders`, {
                headers: {
                    "Content-Type": "application/json",
                    // Authorization: `Bearer ${await this.generateAccessToken()}`,
                    Authorization: `Bearer ${PAYPAL_ACCESS_TOKEN}`
                    // Uncomment one of these to force an error for negative testing (in sandbox mode only). Documentation:
                    // https://developer.paypal.com/tools/sandbox/negative-testing/request-headers/
                    // "PayPal-Mock-Response": '{"mock_application_codes": "MISSING_REQUIRED_PARAMETER"}'
                    // "PayPal-Mock-Response": '{"mock_application_codes": "PERMISSION_DENIED"}'
                    // "PayPal-Mock-Response": '{"mock_application_codes": "INTERNAL_SERVER_ERROR"}'
                },
                method: "POST",
                body: JSON.stringify(payload),
                // body: payload,
            });
            return response.json();
        });
        this.capture = (id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            // /v2/checkout/orders/${orderID}/capture
            // return await this.api.post(`/v2/checkout/orders/${id}/capture`);
            const response = yield fetch(`${this.url}/v2/checkout/orders/${id}/capture`, {
                headers: {
                    "Content-Type": "application/json",
                    // Authorization: `Bearer ${await this.generateAccessToken()}`,
                    Authorization: `Bearer ${PAYPAL_ACCESS_TOKEN}`
                },
                method: "POST",
            });
            return yield response.json();
        });
        this.secretKey = PAYPAL_SECRET;
        this.url = "https://api-m.sandbox.paypal.com";
        // this.instantiateApi();
    }
};
Paypal = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [])
], Paypal);
exports.default = Paypal;
