"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.excelToJson = void 0;
const tslib_1 = require("tslib");
const xlsx_1 = tslib_1.__importDefault(require("xlsx"));
const excelToJson = (dataBuffer, sheet) => {
    // Read the Excel file from a buffer
    const workbook = xlsx_1.default.read(dataBuffer, { type: 'buffer' });
    //   const firstSheetName = workbook.SheetNames[0];
    const sheetIndex = workbook.SheetNames.findIndex(sht => sht === sheet);
    const sheetName = workbook.SheetNames[sheetIndex];
    const worksheet = workbook.Sheets[sheetName];
    const jsonData = xlsx_1.default.utils.sheet_to_json(worksheet);
    return jsonData;
};
exports.excelToJson = excelToJson;
