"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.asyncWrapper = exports.unAuthorized = exports.badRequest = exports.success = exports.serverError = exports.successPaginated = exports.successAction = exports.created = void 0;
const tslib_1 = require("tslib");
function created(res, data, message = "Successful") {
    return res.status(201).json({
        message,
        data,
        success: true,
    });
}
exports.created = created;
function successAction(res, message = "Successful") {
    return res.status(200).json({
        message,
        data: null,
        success: true,
    });
}
exports.successAction = successAction;
function successPaginated(res, data, message = "Fetched successfully") {
    return res.status(200).json({
        message,
        data,
        success: true,
    });
}
exports.successPaginated = successPaginated;
function serverError(res, message = "Something went wrong") {
    return res.status(500).json({
        message,
        error: null,
        success: false,
    });
}
exports.serverError = serverError;
function success(res, data, message = "Successful") {
    return res.status(200).json({
        message,
        data: data,
        success: true,
    });
}
exports.success = success;
function badRequest(res, errors, message = "Bad request") {
    return res.status(400).json({
        message,
        errors,
        success: false,
    });
}
exports.badRequest = badRequest;
function unAuthorized(res, error, message = "Unauthorized request") {
    return res.status(403).json({
        message,
        error,
        success: false,
    });
}
exports.unAuthorized = unAuthorized;
const asyncWrapper = (func) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    try {
        yield func();
    }
    catch (error) {
        // logger.error(error)
        console.error(error);
        throw new Error("...");
    }
});
exports.asyncWrapper = asyncWrapper;
