"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const express_1 = require("express");
const typedi_1 = require("typedi");
const Student_1 = tslib_1.__importDefault(require("../../Validations/Student"));
const Student_2 = tslib_1.__importDefault(require("../../Controller/Student"));
const Middleware_1 = require("../../Middleware");
const injector_1 = tslib_1.__importDefault(require("../../Middleware/injector"));
let StudentRouter = class StudentRouter {
    constructor(studentValidation, studentController, authMiddleWare, injector) {
        this.studentValidation = studentValidation;
        this.studentController = studentController;
        this.authMiddleWare = authMiddleWare;
        this.injector = injector;
        this.path = '/student';
        this.router = (0, express_1.Router)();
        this.initializeRoutes();
    }
    initializeRoutes() {
        this.router.get('/sessions', this.studentController.getAcademicSessions);
        this.router.post('/signin', this.studentValidation.loginValidator, this.studentController.login);
        this.router.get('/', this.authMiddleWare.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.studentController.getProfile);
        this.router.get('/result', this.authMiddleWare.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.studentValidation.validateGetResult, this.studentController.getResult);
        this.router.get('/admission_letter', this.authMiddleWare.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.studentController.generateAdmissionLetter);
        this.router.get('/exam_slip', this.authMiddleWare.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.studentValidation.validateGetExamSlip, this.studentController.getExamSlip);
        this.router.get('/intership_letter', this.authMiddleWare.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.studentValidation.validateGetInternLetter);
    }
};
StudentRouter = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__param(0, (0, typedi_1.Inject)()),
    tslib_1.__param(1, (0, typedi_1.Inject)()),
    tslib_1.__metadata("design:paramtypes", [Student_1.default,
        Student_2.default,
        Middleware_1.AuthMiddleware,
        injector_1.default])
], StudentRouter);
exports.default = StudentRouter;
