"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const express_1 = require("express");
const typedi_1 = require("typedi");
const Middleware_1 = require("../../Middleware");
const Course_1 = tslib_1.__importDefault(require("../../Controller/Course"));
const Course_2 = tslib_1.__importDefault(require("../../Validations/Course"));
const injector_1 = tslib_1.__importDefault(require("../../Middleware/injector"));
let CourseRouter = class CourseRouter {
    constructor(courseController, authMiddleWare, courseValidator, injector) {
        this.courseController = courseController;
        this.authMiddleWare = authMiddleWare;
        this.courseValidator = courseValidator;
        this.injector = injector;
        this.path = '/courses';
        this.router = (0, express_1.Router)();
        this.initializeRoutes();
    }
    initializeRoutes() {
        this.router.get('/:stream', this.authMiddleWare.isStudentAuthenticated, this.courseValidator.validateGetCourse, this.courseController.getAllCourses);
        this.router.post('/register', this.authMiddleWare.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.courseValidator.validateCourseRegistration, this.courseController.register);
        this.router.get('/', this.authMiddleWare.isStudentAuthenticated, this.courseController.getMyCourses);
        this.router.delete('/:id', this.authMiddleWare.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.courseValidator.validateDropCourse, this.courseController.dropCourse);
        this.router.get('/course_form/generate', this.authMiddleWare.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.courseController.generateCourseForm);
    }
};
CourseRouter = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [Course_1.default,
        Middleware_1.AuthMiddleware,
        Course_2.default,
        injector_1.default])
], CourseRouter);
exports.default = CourseRouter;
