"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const express_1 = require("express");
const typedi_1 = require("typedi");
const Aspirant_1 = tslib_1.__importDefault(require("../../Validations/Aspirant"));
const Aspirant_2 = tslib_1.__importDefault(require("../../Controller/Aspirant"));
const injector_1 = tslib_1.__importDefault(require("../../Middleware/injector"));
const Fee_1 = tslib_1.__importDefault(require("../../Validations/Fee"));
const Fee_2 = tslib_1.__importDefault(require("../../Controller/Fee"));
const Middleware_1 = require("../../Middleware");
// import { fileUploadErrorHandler, multerUpload } from "../../Utils/multer/index old_v2";
const multer_1 = require("../../Utils/multer");
const enum_1 = require("../../types/enum");
let AspirantRouter = class AspirantRouter {
    constructor(aspirantValidation, aspirantController, injector, feeValidator, feeController, authMiddleware) {
        this.aspirantValidation = aspirantValidation;
        this.aspirantController = aspirantController;
        this.injector = injector;
        this.feeValidator = feeValidator;
        this.feeController = feeController;
        this.authMiddleware = authMiddleware;
        this.path = '/aspirant';
        this.router = (0, express_1.Router)();
        this.initializeRoutes();
    }
    initializeRoutes() {
        this.router.get('/test', this.aspirantController.test);
        this.router.get('/profile', this.authMiddleware.isAspirantAuthenticatedV2(), this.aspirantController.getProfile);
        this.router.get('/programmes', this.aspirantController.getProfProgrammes);
        this.router.get('/check_application_status/:programme_name', this.injector.injectCurrentSessionAndDiet, this.aspirantValidation.validateCheckApplicationStatus, this.aspirantController.getApplication);
        this.router.get('/ID_card', this.authMiddleware.isAspirantAuthenticatedV2(), this.injector.injectCurrentSessionAndDiet, this.feeController.getIDCardFee);
        this.router.post('/professional', this.aspirantValidation.validateProfSignup, this.aspirantController.signup);
        this.router.get('/professional/email/verify', this.aspirantValidation.emailVerificationValidator, this.injector.injectCurrentSessionAndDiet, this.aspirantController.verifyEmail);
        this.router.post('/professional/:stream/form/pay', this.injector.injectCurrentSessionAndDiet, this.feeValidator.validateFormPayment, this.feeController.payProfFormFee);
        // this.router.post('/professional/:stream/form/verify', this.injector.injectCurrentSessionAndDiet, this.feeValidator.validateFeeVerification, this.feeController.verifyFormPayment);
        this.router.post('/professional/login', this.aspirantValidation.validateLogin, this.injector.injectCurrentSessionAndDiet, this.aspirantController.login);
        this.router.post('/professional/:stream/apply', this.authMiddleware.isProfAspirantAuthenticated, this.aspirantValidation.validateApplication, this.aspirantController.apply);
        this.router.get('/professional/:stream/acceptance', this.authMiddleware.isProfAspirantAuthenticated, this.injector.injectCurrentSessionAndDiet, this.feeValidator.validateGetProfAcceptanceFee, this.feeController.getAcceptanceFee);
        this.router.get('/professional/:stream/acceptance/pay', this.authMiddleware.isProfAspirantAuthenticated, this.injector.injectCurrentSessionAndDiet, this.feeValidator.validateAcceptancePayment, this.feeController.payAcceptanceFee);
        // this.router.post('/professional/:stream/acceptance/verify', this.authMiddleware.isProfAspirantAuthenticated, this.injector.injectCurrentSessionAndDiet, this.feeValidator.validateFeeVerification, this.feeController.verifyAcceptanceFee);
        this.router.get('/professional/:stream/school_fee', this.authMiddleware.isProfAspirantAuthenticated, this.injector.injectCurrentSessionAndDiet, this.feeValidator.validateGetSchoolFee, this.feeController.getSchoolFee);
        this.router.get('/professional/:stream/school_fee/pay', this.authMiddleware.isProfAspirantAuthenticated, this.injector.injectCurrentSessionAndDiet, this.feeValidator.validatePaySchoolFeeAndIDCard, this.feeController.paySchoolFeeAndIDCard); // paid with the ID card
        // this.router.post('/professional/:stream/school_fee/verify', this.authMiddleware.isProfAspirantAuthenticated, this.injector.injectCurrentSessionAndDiet, this.feeValidator.validateSchoolFeeAndIDCardVerification, this.feeController.verifySchoolFeeAndIDCard);
        this.router.get('/professional/:stream/acceptance_school_fee/pay', this.authMiddleware.isProfAspirantAuthenticated, this.injector.injectCurrentSessionAndDiet, this.feeValidator.validatePayAcceptanceSchoolFeeAndIDCard, this.feeController.payAcceptanceSchoolFeeAndIDCard); // paid with the ID card
        // this.router.post('/professional/:stream/acceptance_school_fee/verify', this.authMiddleware.isProfAspirantAuthenticated, this.injector.injectCurrentSessionAndDiet, this.feeValidator.validateAcceptanceSchoolFeeAndIDCardVerification, this.feeController.verifyAcceptanceSchoolFeeAndIDCard);
        // this.router.get('/email', this.aspirantController.resendVerificationCode);
        this.router.get('/putme', this.injector.injectCurrentSessionAndDiet, this.feeController.getPUTMEFee);
        // register and pay
        this.router.post('/full/register', multer_1.multerUpload.fields([{ name: 'o_level', maxCount: 1 }, { name: 'jamb_result', maxCount: 1 }]), this.injector.injectCurrentSessionAndDiet, this.aspirantValidation.validatePUTMEScreening, this.aspirantController.register);
        // this.router.post('/register/PUTME/verify', this.injector.injectCurrentSessionAndDiet, this.feeValidator.validateFeeVerification, this.feeController.verifyPUTMEPayment)
        this.router.post('/full/login', this.aspirantValidation.validateNIDLogin, this.aspirantController.nidLogin);
        // upload admission letter
        this.router.patch('/admission', multer_1.multerUpload.single('adm_letter'), this.authMiddleware.isAspirantAuthenticatedV2(), this.aspirantValidation.validateUploadAdmissionLetter, this.aspirantController.uploadAdmissiionLetter);
        this.router.get('/acceptance', this.authMiddleware.isAspirantAuthenticatedV2(enum_1.NID_Stream.FULL), this.injector.injectCurrentSessionAndDiet, this.feeValidator.validateGetAcceptanceFee, this.feeController.getAcceptanceFee);
        this.router.get('/acceptance/pay', this.authMiddleware.isAspirantAuthenticatedV2(enum_1.NID_Stream.FULL), this.injector.injectCurrentSessionAndDiet, this.feeValidator.validateAcceptancePayment, this.feeController.payAcceptanceFee);
        // this.router.post('/acceptance/verify', this.authMiddleware.isAspirantAuthenticatedV2(NID_Stream.FULL), this.injector.injectCurrentSessionAndDiet, this.feeValidator.validateFeeVerification, this.feeController.verifyAcceptanceFee)
        this.router.get('/school_fee', this.authMiddleware.isAspirantAuthenticatedV2(enum_1.NID_Stream.FULL), this.injector.injectCurrentSessionAndDiet, this.feeValidator.validateGetAcceptanceFee, this.feeController.getSchoolFee);
        this.router.get('/school_fee/pay', this.authMiddleware.isAspirantAuthenticatedV2(enum_1.NID_Stream.FULL), this.injector.injectCurrentSessionAndDiet, this.feeValidator.validatePaySchoolFeeAndIDCard, this.feeController.paySchoolFeeAndIDCard);
        // this.router.post('/school_fee/verify', this.authMiddleware.isAspirantAuthenticatedV2(NID_Stream.FULL), this.injector.injectCurrentSessionAndDiet, this.feeValidator.validateSchoolFeeAndIDCardVerification, this.feeController.verifySchoolFeeAndIDCard);
        this.router.get('/acceptance_school_fee/pay', this.authMiddleware.isAspirantAuthenticatedV2(enum_1.NID_Stream.FULL), this.injector.injectCurrentSessionAndDiet, this.feeValidator.validatePayAcceptanceSchoolFeeAndIDCard, this.feeController.payAcceptanceSchoolFeeAndIDCard); // paid with the ID card
        // this.router.post('/acceptance_school_fee/verify', this.authMiddleware.isAspirantAuthenticatedV2(NID_Stream.FULL), this.injector.injectCurrentSessionAndDiet, this.feeValidator.validateAcceptanceSchoolFeeAndIDCardVerification, this.feeController.verifyAcceptanceSchoolFeeAndIDCard);
        // PART TIME
        this.router.get('/part/application_fee', this.injector.injectCurrentSessionAndDiet, this.feeController.getPartApplicationFee);
        // this.router.post('/part/register', setUploadFolder, multerUpload.fields([{name: 'o_level', maxCount: 1}, {name: 'passport', maxCount: 1}]), this.injector.injectCurrentSessionAndDiet, this.aspirantValidation.validatePartTimeApplication, this.aspirantValidation.validateUpload, this.aspirantController.partTimeApplication);
        this.router.post('/part/register', multer_1.trackUploadedFiles, multer_1.multerUpload.fields([{ name: 'o_level', maxCount: 1 }, { name: 'passport', maxCount: 1 }]), this.injector.injectCurrentSessionAndDiet, this.aspirantValidation.validatePartTimeApplication, this.aspirantValidation.validateUpload, this.aspirantController.partTimeApplication);
        this.router.post('/part/login', this.aspirantValidation.validatePartLogin, this.aspirantController.partLogin);
        this.router.get('/part/application_form', this.authMiddleware.isAspirantAuthenticatedV2(enum_1.NID_Stream.PART), this.aspirantController.generateApplicationForm);
        this.router.use(multer_1.fileUploadErrorHandler);
    }
};
AspirantRouter = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__param(0, (0, typedi_1.Inject)()),
    tslib_1.__metadata("design:paramtypes", [Aspirant_1.default,
        Aspirant_2.default,
        injector_1.default,
        Fee_1.default,
        Fee_2.default,
        Middleware_1.AuthMiddleware])
], AspirantRouter);
exports.default = AspirantRouter;
