"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const typedi_1 = require("typedi");
const express_1 = require("express");
const Admin_1 = tslib_1.__importDefault(require("../../Controller/Admin"));
const Admin_2 = tslib_1.__importDefault(require("../../Validations/Admin"));
const admin_1 = tslib_1.__importDefault(require("../../Middleware/admin"));
const enum_1 = require("../../types/enum");
const injector_1 = tslib_1.__importDefault(require("../../Middleware/injector"));
const multer_1 = require("../../Utils/multer");
const Course_1 = tslib_1.__importDefault(require("../../Controller/Course"));
let AdminRouter = class AdminRouter {
    constructor(adminController, adminValidator, adminMiddleware, injector, courseController) {
        this.adminController = adminController;
        this.adminValidator = adminValidator;
        this.adminMiddleware = adminMiddleware;
        this.injector = injector;
        this.courseController = courseController;
        this.initializerRoutes = () => {
            // initializes the user routes
            this.router.post("/login", this.adminValidator.loginValidator, this.adminController.login);
            this.router.get("/dashboard", this.adminMiddleware.isAuth, this.adminController.getDashboardData);
            // this.router.get("/users", this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(Permisions.READ_USER), this.adminValidator.paginationQueryValidation, this.adminController.getUsers);
            this.router.post("/", this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.CREATE_ADMIN), this.adminController.createAdmin);
            this.router.get("/", this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.SUDO), this.adminController.getAdmins);
            this.router.patch("/:id", this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.SUDO), this.adminValidator.validateEditAdmin, this.adminController.editAdmin);
            this.router.post("/roles", this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.CREATE_ADMIN), this.adminController.createAdminRole);
            this.router.get("/roles", this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.SUDO_ADMIN), this.adminController.getRoles);
            this.router.get('/me', this.adminMiddleware.isAuth, this.adminController.getMe);
            // ... other routes follows
            this.router.get('/sessions', this.adminMiddleware.isAuth, this.adminController.getAllSessions);
            // this.router.get('/programmes', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(Permisions.SUDO), this.injector.injectCurrentSessionAndDiet, this.adminController.getAllProgrammes);
            this.router.get('/programmes', this.injector.injectCurrentSessionAndDiet, this.adminController.getAllProgrammes);
            this.router.get('/programme/:prog_level', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.SUDO), this.adminValidator.validateGetProgrammeByCategory, this.adminController.getProgrammeByCategory);
            this.router.get('/students', this.injector.injectCurrentSessionAndDiet, this.adminController.getStudents);
            this.router.get('/courses/:stream', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.READ_COURSE), this.adminValidator.validateGetCourses, this.adminController.getCourses);
            this.router.get('/courses/:stream/:id', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.READ_COURSE), this.adminValidator.validateGetACourse, this.adminController.getACourse);
            this.router.get('/courses/:stream/stf/assigned', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.READ_COURSE), this.adminValidator.validateGetCourses, this.adminController.getAssignedCourses);
            this.router.post('/courses/:stream/:id/assign', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.SUDO), this.injector.injectCurrentSessionAndDiet, this.adminValidator.validateAssignStaff, this.adminController.assignStaff);
            this.router.get('/courses/:stream/:id/assign', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.READ_COURSE), this.injector.injectCurrentSessionAndDiet, this.adminValidator.validateGetAssignedStaff, this.adminController.getAssignedStaff);
            this.router.get('/aspirants/:stream/applications', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.SUDO_APPLICATION), this.adminValidator.validateGetApplications, this.adminController.getPendingApplications);
            this.router.get('/aspirants/:stream/applications/:id', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.SUDO_APPLICATION), this.adminValidator.validateGetAnApplication, this.adminController.getApplication);
            this.router.patch('/aspirants/:stream/applications/:id', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.SUDO_APPLICATION), this.adminValidator.validateApplicationReview, this.adminController.reviewApplication);
            // results
            this.router.post('/result/:stream', multer_1.multerUpload.single('result'), this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.CREATE_RESULT), this.injector.injectCurrentSessionAndDiet, this.adminController.uploadResult);
            this.router.get('/result/course/:id/:session_id', this.adminMiddleware.isAuth, this.adminValidator.validateGetCourseResult, this.adminController.getCourseResult);
            this.router.get('/download/:file_path', this.adminValidator.validateDownloadFile, this.adminController.download);
            this.router.post('/course/create', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.SUDO), this.adminValidator.validateCreateCourse, this.adminController.createCourse);
            // this.router.get('/courses', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(Permisions.SUDO), this.courseController.getAllCourses);
            this.router.post('/aspirants', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.SUDO), multer_1.multerUpload.single('aspirants'), this.adminValidator.validateUploadAspirant, this.adminController.uploadAspirants);
            this.router.get('/aspirants', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.SUDO), this.adminController.getAspirants);
            this.router.get('/aspirant/:id', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.SUDO), this.adminValidator.validateViewAnAspirant, this.adminController.viewAspirant);
            this.router.post('/aspirants/result', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.SUDO), multer_1.multerUpload.single('result'), this.adminValidator.validatePutmeResultUpload, this.adminController.uploadPutmeResults);
            this.router.patch('/aspirants', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.SUDO), this.adminValidator.validateAspirantsStatus, this.adminController.changeAspirantStatus);
            this.router.get('/aspirants/accepted', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.SUDO), this.adminController.getAcceptedAspirants);
            this.router.get('/aspirants/rejected', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.SUDO), this.adminController.getRejectedAspirants);
            this.router.get('/fees', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.SUDO), this.injector.injectCurrentSessionAndDiet, this.adminController.getAllFee);
            this.router.get('/fees/other', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.SUDO), this.injector.injectCurrentSessionAndDiet, this.adminController.getOtherFee);
            this.router.post('/fees', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.SUDO), this.adminValidator.validateSetFee, this.adminController.setFee);
            this.router.get('/students/:programme_id', this.adminMiddleware.isAuth, this.adminMiddleware.permissionGuard(enum_1.Permisions.SUDO), this.adminValidator.validateGetStudents, this.adminController.getStudentsByProgramme);
            // this.router.post('/file/test', multerUpload.single('result'), this.adminController.testFileUpload)
            this.router.use(multer_1.fileUploadErrorHandler);
        };
        this.path = '/admin';
        this.router = (0, express_1.Router)();
        this.initializerRoutes();
    }
};
AdminRouter = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [Admin_1.default,
        Admin_2.default,
        admin_1.default,
        injector_1.default,
        Course_1.default])
], AdminRouter);
exports.default = AdminRouter;
