"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const typedi_1 = require("typedi");
const studentAdapter_1 = tslib_1.__importDefault(require("../Database/adapters/studentAdapter"));
const api_response_1 = require("../Utils/api_response");
const courseAdapter_1 = tslib_1.__importDefault(require("../Database/adapters/courseAdapter"));
const feeAdapter_1 = tslib_1.__importDefault(require("../Database/adapters/feeAdapter"));
let Injector = class Injector {
    constructor(studentAdapter, courseAdaper, feeAdapter) {
        this.studentAdapter = studentAdapter;
        this.courseAdaper = courseAdaper;
        this.feeAdapter = feeAdapter;
        // public injectProgramme = async (req: Request, res: Response, next: NextFunction) => {
        //     try {
        //         const { auth_user } = req.body;
        //         const programme = this.feeAdapter.DBGetProgramme(auth_user.prog_level);
        //         req.body = {
        //             ...req.body,
        //             programme: {
        //                 ...programme
        //             }
        //         }
        //         return next();
        //     } catch (error) {
        //         return serverError(res); 
        //     }
        // }
        // public injectEnrollmentData = async (req: Request, res: Response, next: NextFunction) => {
        //     try {
        //         const { auth_user } = req.body;
        //         const data = await this.studentAdapter.DBGetEnrollmentData(auth_user.id);
        //         req.body = {
        //             ...req.body,
        //             auth_user: {
        //                 ...auth_user,
        //                 ...data
        //             }
        //         }
        //         return next();
        //     } catch (error) {
        //         return serverError(res);   
        //     }
        // }
        this.injectCurrentSessionAndDiet = (req, res, next) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const session = yield this.courseAdaper.DBGetCurrentSessionAndDiet();
                req.body.session = session;
                return next();
            }
            catch (error) {
                return (0, api_response_1.serverError)(res);
            }
        });
    }
};
Injector = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [studentAdapter_1.default,
        courseAdapter_1.default,
        feeAdapter_1.default])
], Injector);
exports.default = Injector;
