"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setUploadFolder = exports.AuthMiddleware = void 0;
const tslib_1 = require("tslib");
const api_response_1 = require("../Utils/api_response");
const jwt_1 = require("../Utils/jwt");
const typedi_1 = require("typedi");
const authAdapter_1 = tslib_1.__importDefault(require("../Database/adapters/authAdapter"));
const enum_1 = require("../types/enum");
const promises_1 = tslib_1.__importDefault(require("fs/promises"));
const path_1 = tslib_1.__importDefault(require("path"));
const uuid_1 = require("uuid");
let AuthMiddleware = class AuthMiddleware {
    constructor(authAdapter) {
        this.authAdapter = authAdapter;
        this.isProfAspirantAuthenticated = (req, res, next) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { authorization } = req.headers;
            if (!authorization || !authorization.startsWith("Bearer")) {
                return (0, api_response_1.unAuthorized)(res, "Invalid token");
            }
            try {
                const token = authorization.split(" ")[1];
                const { email, stream } = (0, jwt_1.decodeProfAspirantToken)(token);
                const aspirant = yield this.authAdapter.GetProfAspirant(email, stream);
                if (!aspirant) {
                    return (0, api_response_1.unAuthorized)(res, "Invalid token");
                }
                req.body = Object.assign(Object.assign({}, req.body), { auth_user: Object.assign({}, aspirant) });
                console.log(req.body.auth_user, 'authywer');
                return next();
            }
            catch (error) {
                return (0, api_response_1.unAuthorized)(res, "Invalid token");
            }
        });
        this.isAspirantAuthenticatedV2 = (stream) => (req, res, next) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { authorization } = req.headers;
            if (!authorization || !authorization.startsWith("Bearer")) {
                return (0, api_response_1.unAuthorized)(res, "Invalid token");
            }
            try {
                const token = authorization.split(" ")[1];
                const { id, stream: signedNIDStream, jamb_reg } = (0, jwt_1.decodeAspirantToken)(token);
                // const { email, stream: signedProfStream } = decodeProfAspirantToken(token);
                let aspirant;
                // console.log(decodeAspirantToken(token))
                // console.log(decodeProfAspirantToken(token))
                if (stream === enum_1.NID_Stream.FULL) {
                    aspirant = yield this.authAdapter.DBGetAspirant(id, signedNIDStream, jamb_reg);
                }
                else if (stream === enum_1.NID_Stream.PART) {
                    aspirant = yield this.authAdapter.DBGetAspirant(id, signedNIDStream, jamb_reg);
                }
                // else if(stream !== NID_Stream.FULL && stream !== NID_Stream.PART && !jamb_reg) {
                //   aspirant = await this.authAdapter.GetProfAspirant(email, signedProfStream);
                // } 
                else {
                    aspirant = yield this.authAdapter.DBGetAspirant(id);
                }
                if (!aspirant) {
                    return (0, api_response_1.unAuthorized)(res, "Invalid token");
                }
                req.body = Object.assign(Object.assign({}, req.body), { auth_user: Object.assign({}, aspirant) });
                return next();
            }
            catch (error) {
                return (0, api_response_1.unAuthorized)(res, "Invalid token");
            }
        });
        // public isNIDAspirantAuthenticated = async (req: Request, res: Response, next: NextFunction) => {
        //   const { authorization } = req.headers;
        //   if (!authorization || !authorization.startsWith("Bearer")) {
        //     return unAuthorized(res, "Invalid token");
        //   }
        //   try {
        //     const token = authorization.split(" ")[1];
        //     const { id, jamb_reg } = decodeAspirantToken(token);
        //     const aspirant = await this.authAdapter.DBGetAspirant(id, jamb_reg);
        //     if (!aspirant) {
        //       return unAuthorized(res, "Invalid token");
        //     }
        //     req.body = {
        //       ...req.body,
        //       auth_user: {
        //         ...aspirant,
        //       }
        //     }
        //     return next();
        //   } catch (error) {
        //     return unAuthorized(res, "Invalid token");
        //   }
        // }
        // public isAspirantAuthenticated = async (req: Request, res: Response, next: NextFunction) => {
        //   const { authorization } = req.headers;
        //   if (!authorization || !authorization.startsWith("Bearer")) {
        //     return unAuthorized(res, "Invalid token");
        //   }
        //   try {
        //     const token = authorization.split(" ")[1];
        //     const { id, jamb_reg } = decodeAspirantToken(token);
        //     const { email, stream } = decodeProfAspirantToken(token);
        //     let aspirant;
        //     // console.log(decodeAspirantToken(token))
        //     // console.log(decodeProfAspirantToken(token))
        //     if(!jamb_reg) {
        //       aspirant = await this.authAdapter.GetProfAspirant(email, stream);
        //     } else {
        //       aspirant = await this.authAdapter.DBGetAspirant(id, jamb_reg);
        //     }
        //     if (!aspirant) {
        //       return unAuthorized(res, "Invalid token");
        //     }
        //     req.body = {
        //       ...req.body,
        //       auth_user: {
        //         ...aspirant,
        //       }
        //     }
        //     return next();
        //   } catch (error) {
        //     return unAuthorized(res, "Invalid token");
        //   }
        // }
        this.isStudentAuthenticated = (req, res, next) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { authorization } = req.headers;
            if (!authorization || !authorization.startsWith("Bearer")) {
                return (0, api_response_1.unAuthorized)(res, "Invalid token");
            }
            try {
                const token = authorization.split(" ")[1];
                const { id, matric_no } = (0, jwt_1.decodeToken)(token);
                const student = yield this.authAdapter.GetStudent(id, matric_no);
                if (!student) {
                    return (0, api_response_1.unAuthorized)(res, "Invalid token");
                }
                req.body = Object.assign(Object.assign({}, req.body), { auth_user: Object.assign({}, student) });
                return next();
            }
            catch (error) {
                return (0, api_response_1.unAuthorized)(res, "Invalid token");
            }
        });
    }
};
exports.AuthMiddleware = AuthMiddleware;
exports.AuthMiddleware = AuthMiddleware = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [authAdapter_1.default])
], AuthMiddleware);
const setUploadFolder = (req, res, next) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    var _a;
    // const uniqueFolder = `${Date.now()}-${Math.random().toString(36).substr(2, 5)}`;
    const uniqueFolder = (0, uuid_1.v4)();
    const uploadDir = path_1.default.join((_a = process.env.UPLOAD_PATH) !== null && _a !== void 0 ? _a : 'public/uploads', uniqueFolder);
    // Ensure the directory exists
    yield promises_1.default.mkdir(uploadDir, { recursive: true });
    // Attach the upload directory to req for use in multer
    req.body.uploadDir = uploadDir;
    next();
});
exports.setUploadFolder = setUploadFolder;
