"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.seed = void 0;
const tslib_1 = require("tslib");
const db_types_1 = require("../../types/db.types");
const enum_1 = require("../../types/enum");
const fees = [
    {
        name: enum_1.Fee_Type.FORM,
        description: "",
        amount: 10000,
        is_recurrent: false,
        upfront: false,
        category: enum_1.Category.PROFESSIONAL,
        session: '2024/2025'
    },
    {
        name: enum_1.Fee_Type.ACCEPTANCE,
        description: "",
        amount: 10000,
        is_recurrent: false,
        upfront: false,
        category: enum_1.Category.PROFESSIONAL,
        session: '2024/2025'
    },
    {
        name: enum_1.Fee_Type.TUITION,
        description: "",
        amount: 67000,
        is_recurrent: false,
        upfront: true,
        category: enum_1.Category.BASIC,
        session: '2024/2025'
    },
    {
        name: enum_1.Fee_Type.TUITION,
        description: "",
        amount: 77000,
        is_recurrent: false,
        upfront: true,
        category: enum_1.Category.ADVANCED,
        session: '2024/2025'
    },
    {
        name: enum_1.Fee_Type.ID_CARD,
        description: "",
        amount: 1000,
        is_recurrent: false,
        upfront: false,
        category: enum_1.Category.PROFESSIONAL,
        session: '2024/2025'
    },
    {
        name: enum_1.Fee_Type.ID_CARD,
        description: "",
        amount: 2000,
        is_recurrent: false,
        upfront: false,
        category: enum_1.Category.NID,
        session: '2024/2025'
    },
    {
        name: enum_1.Fee_Type.PUTME,
        description: "",
        amount: 2000,
        is_recurrent: false,
        upfront: false,
        category: enum_1.Category.FULL,
        session: '2024/2025'
    },
    {
        name: enum_1.Fee_Type.ACCEPTANCE,
        description: "",
        amount: 40000,
        is_recurrent: false,
        upfront: false,
        category: enum_1.Category.FULL,
        session: '2024/2025'
    },
    {
        name: enum_1.Fee_Type.TUITION,
        description: "",
        amount: 150000,
        is_recurrent: false,
        upfront: true,
        category: enum_1.Category.FULL,
        session: '2024/2025'
    },
    {
        name: enum_1.Fee_Type.PART_FORM,
        description: "",
        amount: 10000,
        is_recurrent: false,
        upfront: false,
        category: enum_1.Category.PART,
        session: '2024/2025'
    },
    {
        name: enum_1.Fee_Type.ACCEPTANCE,
        description: "",
        amount: 40000,
        is_recurrent: false,
        upfront: false,
        category: enum_1.Category.PART,
        session: '2024/2025'
    },
    {
        name: enum_1.Fee_Type.TUITION,
        description: "",
        amount: 165000,
        is_recurrent: false,
        upfront: true,
        category: enum_1.Category.PART,
        session: '2024/2025'
    }
];
function seed(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const new_fee = [];
        yield Promise.all(fees.map((f) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            const sessions = yield knex.select('*').from(db_types_1.ETables.ACADEMIC_SESSION);
            const session = sessions.find(ss => ss.name === f.session);
            if (!session)
                console.error('Session not found');
            const fe = yield knex.select('*').from(db_types_1.ETables.FEE).where('name', f.name).andWhere('category', f.category).andWhere('session_id', session.id).first();
            const { name, description, amount, is_recurrent, upfront, category } = f;
            if (!fe) {
                new_fee.push({ name, description, amount, is_recurrent, upfront, category, session_id: session.id });
            }
            else {
                console.log(`Fee ${f.name} already exists`);
            }
            // delete f.session;
        })));
        new_fee.length && (yield knex(db_types_1.ETables.FEE).insert(new_fee));
    });
}
exports.seed = seed;
// export async function seed(knex: Knex): Promise<void> {
//     await Promise.all(fees.map(async f => {
//         const sessions = await knex.select('*').from(ETables.ACADEMIC_SESSION);
//         const session = sessions.find(ss => ss.name === f.session);
//         if (!session) console.error('Session not found');
//         // delete f.session;
//         const { name, description, amount, is_recurrent, upfront, category } = f;
//         await knex(ETables.FEE).insert({ name, description, amount, is_recurrent, upfront, category, session_id: session.id });
//     }))
// }
