"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.seed = void 0;
const tslib_1 = require("tslib");
const db_types_1 = require("../../types/db.types");
const sessions = [
    {
        name: '2024/2025',
        start_date: new Date(2024, 2, 20),
        end_date: new Date(2024, 4, 20),
        is_current: true,
    }
];
const diets = [
    {
        number: 10,
        year: 2024,
        session: '2024/2025',
        is_current: true
    },
    {
        number: 11,
        year: 2024,
        session: '2024/2025',
        is_current: false
    },
    {
        number: 12,
        year: 2025,
        session: '2024/2025',
        is_current: false
    },
];
function seed(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        yield knex.transaction((trx) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            // Insert sessions
            yield insertSessionsIfNeeded(sessions, trx);
            // Insert diets after confirming session insertions
            yield insertDietsIfNeeded(diets, trx);
        }));
    });
}
exports.seed = seed;
function insertSessionsIfNeeded(sessions, trx) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        for (const session of sessions) {
            const existingSession = yield trx.select('*').from(db_types_1.ETables.ACADEMIC_SESSION).where("name", session.name).first();
            if (!existingSession) {
                yield trx(db_types_1.ETables.ACADEMIC_SESSION).insert(session);
            }
            else {
                console.log(`Session ${session.name} already exists in the db`);
            }
        }
    });
}
function insertDietsIfNeeded(diets, trx) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        for (const diet of diets) {
            const session = yield trx.select('*').from(db_types_1.ETables.ACADEMIC_SESSION).where('name', diet.session).first();
            if (!session) {
                console.log(`Session ${diet.session} not found for diet number ${diet.number}. Skipping insertion.`);
                continue;
            }
            const existingDiet = yield trx.select('*').from(db_types_1.ETables.DIET)
                .where('number', diet.number)
                .andWhere('session_id', session.id)
                .first();
            if (!existingDiet) {
                yield trx(db_types_1.ETables.DIET).insert({
                    number: diet.number,
                    year: diet.year,
                    is_current: diet.is_current,
                    session_id: session.id
                });
            }
            else {
                console.log(`Diet ${diet.number} already exists in the database.`);
            }
        }
    });
}
// export async function seed(knex: Knex): Promise<void> {
//     await knex.transaction(async trx => {
//         const new_session: any[] = [];
//         const new_diet: any[] = [];
//         await Promise.all(session.map(async sessn => {
//             const ss = await trx.select('*').from(ETables.ACADEMIC_SESSION).where("name", sessn.name).first();
//             if(!ss) {
//                 new_session.push(sessn);
//             } else {
//                 console.log(`Session ${sessn.name} already exists in the db`);
//             }
//             for(let dit of diets) {
//                 const sessioon = await trx.select('*').from(ETables.ACADEMIC_SESSION).where('name', dit.session).first();
//                 if(!sessioon) continue;
//                 const dd = await trx.select('*').from(ETables.DIET).where('number', dit.number).andWhere('session_id', sessioon.id).first();
//                 const { number, year, is_current } = dit
//                 if(!dd) {
//                     new_diet.push({ number, year, is_current, session_id: sessioon.id });
//                 } else {
//                     console.log(`Diet ${dit.number} already exist`)
//                 }
//             }
//         }))
//         new_session.length && await trx(ETables.ACADEMIC_SESSION).insert(new_session);
//         new_diet.length && await trx(ETables.DIET).insert(new_diet);
//     })
// };
// export async function seed(knex: Knex): Promise<void> {
//     await knex.transaction(async trx => {
//         await Promise.all(session.map(async sessn => {
//             const new_session = [];
//             const ss = await trx.select('*').from(ETables.ACADEMIC_SESSION).where("name", sessn.name).first();
//             !ss && new_session.push(sessn);
//             if(new_session.length) {
//                 await trx(ETables.ACADEMIC_SESSION).insert(new_session);
//             } else {
//                 console.log(`Session ${sessn.name} already exists in the db`);
//             }
//             const new_diet = [];
//             for(let dit of diets) {
//                 const sessioon = await trx.select('*').from(ETables.ACADEMIC_SESSION).where('name', dit.session).first();
//                 const dd = await trx.select('*').from(ETables.DIET).where('number', dit.number).andWhere('session_id', sessioon.id);
//                 const { number, year, is_current } = dit
//                 !dd && new_diet.push({ number, year, is_current, session_id: sessioon.id });
//                 if(new_diet.length) {
//                     await trx(ETables.DIET).insert(new_diet);
//                 } else {
//                     console.log(`Diet ${dit.number} already exist`)
//                 }
//             }
//         }))
//     })
// };
