"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const tslib_1 = require("tslib");
const db_types_1 = require("../../types/db.types");
const enum_1 = require("../../types/enum");
function up(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.createTable(db_types_1.ETables.COURSE_REG, (table) => {
            table.increments("id", { primaryKey: true });
            table.float('grade').notNullable().defaultTo(0.00);
            table.float('CA').notNullable().defaultTo(0.00);
            table.float('exam').notNullable().defaultTo(0.00);
            table.enum('current_level', Object.values(enum_1.Level)).notNullable(); //student level itself
            table.integer("student_id").unsigned();
            table.foreign("student_id").references("id").inTable(db_types_1.ETables.STUDENT);
            table.integer("course_id").unsigned();
            table.foreign("course_id").references("id").inTable(db_types_1.ETables.COURSES);
            // table.boolean('result_uploaded').notNullable().defaultTo(false);
            table.integer("session_id").unsigned();
            table.foreign("session_id").references("id").inTable(db_types_1.ETables.ACADEMIC_SESSION);
            table.timestamps(true, true);
            table.unique(["student_id", "course_id", "session_id"], { indexName: "unique_course_per_session" });
        });
    });
}
exports.up = up;
function down(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.dropTable(db_types_1.ETables.COURSE_REG);
    });
}
exports.down = down;
