"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const tslib_1 = require("tslib");
const db_types_1 = require("../../types/db.types");
const enum_1 = require("../../types/enum");
function up(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.createTable(db_types_1.ETables.STUDENT_FEE, (table) => {
            table.increments("id", { primaryKey: true });
            table.decimal('amount_due', 14, 2).notNullable();
            table.decimal('amount_paid', 14, 2).notNullable();
            table.decimal('balance', 14, 2).notNullable();
            table.enum('stream', Object.values(enum_1.Stream));
            table.integer('year').notNullable();
            table.boolean('completed').notNullable();
            table.string('reference').notNullable();
            table.integer("diet_id").unsigned();
            table.foreign("diet_id").references("id").inTable(db_types_1.ETables.DIET);
            table.integer("fee_id").unsigned();
            table.foreign("fee_id").references("id").inTable(db_types_1.ETables.FEE);
            table.integer("student_id").unsigned();
            table.foreign("student_id").references("id").inTable(db_types_1.ETables.STUDENT);
            table.integer("programme_id").unsigned();
            table.foreign("programme_id").references("id").inTable(db_types_1.ETables.PROGRAMME);
            table.integer("session_id").unsigned();
            table.foreign("session_id").references("id").inTable(db_types_1.ETables.ACADEMIC_SESSION);
            table.timestamps(true, true);
        });
        // .raw(`
        //   ALTER TABLE ${ETables.STUDENT_FEE}
        //   ADD CONSTRAINT check_stream_diet_id_nullability
        //   CHECK (
        //     stream <> 'standard' AND diet_id IS NOT NULL 
        //   )
        // `);
    });
}
exports.up = up;
function down(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.dropTable(db_types_1.ETables.STUDENT_FEE);
    });
}
exports.down = down;
