"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const tslib_1 = require("tslib");
const db_types_1 = require("../../types/db.types");
function up(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        yield knex.schema.createTable(db_types_1.ETables.ADMIN_ROLE, t => {
            t.increments("id", { primaryKey: true });
            t.string("permissions").notNullable();
            t.string("title").notNullable().unique();
            t.string("description").nullable();
            t.timestamps(true, true);
        }).createTable(db_types_1.ETables.ADMIN, t => {
            t.increments("id", { primaryKey: true });
            t.string("email").unique().notNullable();
            t.string("password").notNullable();
            t.integer("role_id").unsigned();
            t.foreign("role_id").references("id").inTable(db_types_1.ETables.ADMIN_ROLE);
            t.string("name").notNullable();
            t.timestamps(true, true);
            t.string("username").unique();
        });
    });
}
exports.up = up;
function down(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        yield knex.schema.dropTable(db_types_1.ETables.ADMIN).dropTable(db_types_1.ETables.ADMIN_ROLE);
    });
}
exports.down = down;
