"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const tslib_1 = require("tslib");
const db_types_1 = require("../../types/db.types");
const enum_1 = require("../../types/enum");
function up(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.createTable(db_types_1.ETables.STUDENT, (table) => {
            table.increments("id", { primaryKey: true });
            table.string("first_name", 255).notNullable();
            table.string("last_name", 255).notNullable();
            table.string("middle_name", 255);
            table.string("email").unique().notNullable();
            table.string("phone").notNullable();
            table.date('DOB').notNullable();
            table.enum("gender", Object.values(enum_1.Gender)).notNullable();
            table.string('adm_no').notNullable();
            table.string('matric_no').notNullable();
            table.string("password").notNullable();
            table.float("GP").unsigned().notNullable().defaultTo(0.00);
            table.float("CGP").unsigned().notNullable().defaultTo(0.00);
            table.enum("level", Object.values(enum_1.Level)).notNullable();
            table.enu('stream', Object.values(enum_1.Stream)).notNullable();
            table.boolean('paid').notNullable().defaultTo(false);
            table.enum("status", Object.values(enum_1.Status)).notNullable().defaultTo(enum_1.Status.PENDING);
            table.timestamps(true, true);
        });
    });
}
exports.up = up;
function down(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.dropTable(db_types_1.ETables.STUDENT);
    });
}
exports.down = down;
