"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const tslib_1 = require("tslib");
const db_types_1 = require("../../types/db.types");
const enum_1 = require("../../types/enum");
function up(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.createTable(db_types_1.ETables.ASPIRANT, (table) => {
            table.increments("id", { primaryKey: true });
            table.string("first_name", 255).notNullable();
            table.string("last_name", 255).notNullable();
            table.string("middle_name", 255);
            table.string("email").unique().notNullable();
            table.date('DOB');
            table.enum("gender", Object.values(enum_1.Gender)).notNullable();
            table.string("phone").notNullable();
            table.string('jamb_reg');
            table.string("password").notNullable();
            table.string('state_of_origin');
            table.string('lga');
            table.string('address');
            table.json("manual_o_level");
            table.binary("o_level");
            table.string('o_level_mimetype');
            table.binary("jamb_result");
            table.string('jamb_result_mimetype');
            table.float('score').notNullable().defaultTo(0.00);
            table.binary("adm_letter");
            table.string('adm_letter_mimetype');
            table.boolean('paid').notNullable().defaultTo(false);
            table.enum("status", Object.values(enum_1.Status)).notNullable().defaultTo(enum_1.Status.PENDING);
            table.specificType("passport", 'LONGBLOB');
            table.string('passport_mimetype');
            table.integer("diet_id").unsigned();
            table.foreign("diet_id").references("id").inTable(db_types_1.ETables.DIET);
            table.integer("programme_id").unsigned();
            table.foreign("programme_id").references("id").inTable(db_types_1.ETables.PROGRAMME);
            table.integer("session_id").unsigned();
            table.foreign("session_id").references("id").inTable(db_types_1.ETables.ACADEMIC_SESSION);
            table.timestamps(true, true);
        });
    });
}
exports.up = up;
function down(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.dropTable(db_types_1.ETables.ASPIRANT);
    });
}
exports.down = down;
