"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const tslib_1 = require("tslib");
const db_types_1 = require("../../types/db.types");
const enum_1 = require("../../types/enum");
function up(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.createTable(db_types_1.ETables.FEE, (table) => {
            table.increments("id", { primaryKey: true });
            table.string("name", 255).notNullable();
            table.string("description", 255);
            table.decimal('amount', 14, 2).notNullable();
            table.boolean('is_recurrent').notNullable();
            table.boolean('upfront').notNullable();
            table.enum("category", Object.values(enum_1.Category)).notNullable();
            // table.integer("programme_id").unsigned()
            // table.foreign("programme_id").references("id").inTable(ETables.PROGRAMME);
            table.integer("session_id").unsigned();
            table.foreign("session_id").references("id").inTable(db_types_1.ETables.ACADEMIC_SESSION);
            table.timestamps(true, true);
            table.unique(["name", "session_id", "category"], { indexName: "unique_fee_category_session" });
        });
    });
}
exports.up = up;
function down(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.dropTable(db_types_1.ETables.FEE);
    });
}
exports.down = down;
