"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StudentValidatorAdapter = void 0;
const tslib_1 = require("tslib");
const typedi_1 = require("typedi");
const _1 = tslib_1.__importStar(require("."));
const db_types_1 = require("../../types/db.types");
let StudentAdapter = class StudentAdapter extends _1.BaseAdapter {
    constructor() {
        super();
        this.DBCreateStudent = (auth_user, password, adm_no, paid, level, diet_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                return yield _1.default.transaction((trx) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                    // const { id, first_name, last_name, middle_name, email, DOB, stream, description, ...enrlData } = auth_user
                    const { first_name, last_name, middle_name, email, DOB, gender, phone, stream, jamb_reg, qualification, workplace, years_of_exp, programme_id, session_id } = auth_user;
                    const dateOnly = new Date(DOB).toISOString().split('T')[0];
                    console.log({ first_name, last_name, middle_name, email, password, DOB: dateOnly, gender, phone, stream: stream, adm_no, paid, matric_no: adm_no.split('/').pop(), level, programme_id });
                    const [student] = yield trx(db_types_1.ETables.STUDENT).insert({ first_name, last_name, middle_name, email, password, DOB: dateOnly, gender, phone, stream: stream, adm_no, paid, matric_no: adm_no.split('/').pop(), level });
                    yield trx(db_types_1.ETables.ENROLLMENT).insert({ qualification, workplace, years_of_exp, stream: stream, enrollment_date: new Date(), completion_date: new Date(), jamb_reg, programme_id, student_id: student, session_id, diet_id });
                    return student;
                }));
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.getProgrammeByStream = (stream) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const programme = yield _1.default.select('*').from(db_types_1.ETables.PROGRAMME).where('stream', stream).first();
                return programme;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.getDietById = (id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const diet = yield _1.default.select('*').from(db_types_1.ETables.DIET).where('id', id).first();
                return diet;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetAcademicSessions = () => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const sessions = yield _1.default.select('*').from(db_types_1.ETables.ACADEMIC_SESSION);
                return sessions;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetStudent = (matric_no) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const student = yield _1.default.select('*').from(db_types_1.ETables.STUDENT).where("matric_no", matric_no).first();
                return student;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetProfile = (matric_no) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const profile = yield _1.default.select([
                    "std.id as id",
                    "std.first_name as first_name",
                    "std.last_name as last_name",
                    "std.middle_name as middle_name",
                    "std.email as email",
                    "std.adm_no as adm_no",
                    "std.matric_no as matric_no",
                    "std.phone as phone",
                    "std.DOB as DOB",
                    "std.gender as gender",
                    "std.GP as GP",
                    "std.CGP as CGP",
                    "std.level as level",
                    "std.stream as stream",
                    "enrl.entry_session as entry_session",
                    "enrl.jamb_reg as jamb_reg",
                    "enrl.enrollment_date as enrollment_date",
                    "enrl.completion_date as completion_date",
                    "enrl.programme_id as programme_id",
                    "prg.duration as duration",
                    "prg.name as programme",
                    "prg.description as programme_description",
                    // "prg.stream as stream",
                    "diet.number as diet",
                    "diet.year as diet_year",
                ])
                    .from({ std: db_types_1.ETables.STUDENT })
                    .join({ enrl: db_types_1.ETables.ENROLLMENT }, "enrl.student_id", "std.id")
                    .leftJoin({ prg: db_types_1.ETables.PROGRAMME }, "prg.id", "enrl.programme_id")
                    .leftJoin({ diet: db_types_1.ETables.DIET }, 'diet.id', 'enrl.diet_id')
                    .where("matric_no", matric_no).first();
                // console.log(profile);
                return profile;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetResult = (student_id, level, session_id, semester) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const results = yield _1.default.select([
                    "reg.CA as CA",
                    "reg.exam as exam",
                    "reg.grade as grade",
                    "reg.current_level as level",
                    "reg.course_id as course_id",
                    "course.code as code",
                    "course.title as title",
                    "course.description as description",
                    "course.unit as unit",
                    "course.type as type",
                    "course.semester as semester",
                    "reg.session_id as session_id"
                ])
                    .from({ reg: db_types_1.ETables.COURSE_REG })
                    .join({ course: db_types_1.ETables.COURSES }, 'course.id', 'reg.course_id')
                    .where('student_id', student_id).andWhere('current_level', level).andWhere('session_id', session_id);
                return results;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetWeight = (score) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                console.log(score);
                const weight = yield _1.default.select('*').from(db_types_1.ETables.GRADE).where("mark_min", '<=', score).andWhere("mark_max", ">=", score).first();
                console.log(weight);
                return weight;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DGGetCummulativeResullt = (student_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const results = yield _1.default.select([
                    "reg.grade as grade",
                    "reg.current_level as level",
                    "reg.course_id as course_id",
                    "course.code as code",
                    "course.title as title",
                    "course.description as description",
                    "course.unit as unit",
                    "course.type as type",
                    "course.semester as semester",
                    "reg.session_id as session_id"
                ])
                    .from({ reg: db_types_1.ETables.COURSE_REG })
                    .join({ course: db_types_1.ETables.COURSES }, 'course.id', 'reg.course_id')
                    .where('student_id', student_id);
                return results;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetCOD = (cgpa) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                console.log(cgpa, 'cgpa');
                const cod = yield _1.default.select('*').from(db_types_1.ETables.CGPA_GRADE).where("mark_min", '<=', cgpa).andWhere("mark_max", ">=", cgpa).first();
                console.log(cod);
                return cod || 'Fail';
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetEnrollmentData = (student_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const data = yield _1.default.select('*').from(db_types_1.ETables.ENROLLMENT).where('student_id', student_id).first();
                return data;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
    }
};
StudentAdapter = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [])
], StudentAdapter);
let StudentValidatorAdapter = class StudentValidatorAdapter extends _1.BaseAdapter {
    constructor() {
        super();
        this.DBGetStudent = (matric_no) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const student = yield _1.default.select('*').from(db_types_1.ETables.STUDENT).where("matric_no", matric_no).first();
                return student;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBIsValidSession = (id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const session = yield _1.default.select('*').from(db_types_1.ETables.ACADEMIC_SESSION).where("id", id).first();
                return !!session;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
    }
};
exports.StudentValidatorAdapter = StudentValidatorAdapter;
exports.StudentValidatorAdapter = StudentValidatorAdapter = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [])
], StudentValidatorAdapter);
exports.default = StudentAdapter;
