"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pay_refValidatorAdapter = void 0;
const tslib_1 = require("tslib");
const typedi_1 = require("typedi");
const _1 = tslib_1.__importStar(require("."));
const db_types_1 = require("../../types/db.types");
let Pay_refAdapter = class Pay_refAdapter extends _1.BaseAdapter {
    constructor() {
        super();
        this.DBSavePaymentRef = (email, reference, description) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                yield (0, _1.default)(db_types_1.ETables.PAY_REF).insert({ email, reference, description });
            }
            catch (error) {
                return this.catchError(error);
            }
        });
    }
};
Pay_refAdapter = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [])
], Pay_refAdapter);
let Pay_refValidatorAdapter = class Pay_refValidatorAdapter extends _1.BaseAdapter {
    constructor() {
        super();
        this.DBReferenceUsed = (reference) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const used = yield _1.default.select('*').from(db_types_1.ETables.PAY_REF).where("reference", reference).first();
                return !!used;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
    }
};
exports.Pay_refValidatorAdapter = Pay_refValidatorAdapter;
exports.Pay_refValidatorAdapter = Pay_refValidatorAdapter = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [])
], Pay_refValidatorAdapter);
exports.default = Pay_refAdapter;
