"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CourseValidatorAdapter = void 0;
const tslib_1 = require("tslib");
const typedi_1 = require("typedi");
const _1 = tslib_1.__importStar(require("."));
const db_types_1 = require("../../types/db.types");
let CourseAdapter = class CourseAdapter extends _1.BaseAdapter {
    constructor() {
        super();
        this.DBGetCurrentSessionAndDiet = () => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const seesion = yield _1.default.select('*').from(db_types_1.ETables.ACADEMIC_SESSION).where("is_current", true).first();
                const diet = yield _1.default.select('*').from(db_types_1.ETables.DIET).where("is_current", true).andWhere('session_id', seesion.id).first();
                seesion['current_diet'] = diet;
                return seesion;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetAllCourses = (stream) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const courses = yield _1.default.select('*').from(db_types_1.ETables.COURSES).where('stream', stream);
                return courses;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetCourseById = (id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const course = yield _1.default.select('*').from(db_types_1.ETables.COURSES).where('id', id).first();
                return course;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetMyCourses = (user_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const courses = yield _1.default.select([
                    "reg.*",
                    "course.id as course_id",
                    "course.code as code",
                    "course.title as title",
                    "course.description as description",
                    "course.unit as unit",
                    "course.type as type",
                    "course.semester as semester",
                ])
                    .from({ reg: db_types_1.ETables.COURSE_REG })
                    .join({ course: db_types_1.ETables.COURSES }, 'course.id', 'reg.course_id')
                    .where('student_id', user_id);
                return courses;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBRegister = (user_id, ids, session_id, current_level) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const reg = [];
                for (let id of ids) {
                    const obj = {
                        current_level,
                        course_id: id,
                        student_id: user_id,
                        session_id
                    };
                    reg.push(obj);
                }
                ;
                yield (0, _1.default)(db_types_1.ETables.COURSE_REG).insert(reg);
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBDropCourse = (student_id, course_id, session_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                yield (0, _1.default)(db_types_1.ETables.COURSE_REG).where("student_id", student_id).andWhere({ course_id, session_id }).delete();
            }
            catch (error) {
                return this.catchError(error);
            }
        });
    }
};
CourseAdapter = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [])
], CourseAdapter);
let CourseValidatorAdapter = class CourseValidatorAdapter extends _1.BaseAdapter {
    constructor() {
        super();
        this.DBGetCourseById = (id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const course = yield _1.default.select(['id', 'code']).from(db_types_1.ETables.COURSES).where("id", id).first();
                return course;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBHasCourseForCurrentSession = (id, student_id, session_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const course = yield _1.default.select('*').from(db_types_1.ETables.COURSE_REG).where("session_id", session_id).andWhere("student_id", student_id).andWhere("course_id", id).first();
                return !!course;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetAllCourses = (stream) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const course = yield _1.default.select('*').from(db_types_1.ETables.COURSES).where('stream', stream);
                return course;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBCourseAlreadyAssignedForTheSession = (id, session_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const course = yield _1.default.select('*').from(db_types_1.ETables.ASSIGNED_COURSES).where('course_id', id).andWhere('session_id', session_id).first();
                return course;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
    }
};
exports.CourseValidatorAdapter = CourseValidatorAdapter;
exports.CourseValidatorAdapter = CourseValidatorAdapter = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [])
], CourseValidatorAdapter);
exports.default = CourseAdapter;
