"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const typedi_1 = require("typedi");
const _1 = tslib_1.__importStar(require("."));
const db_types_1 = require("../../types/db.types");
let AuthAdapter = class AuthAdapter extends _1.BaseAdapter {
    constructor() {
        super();
        this.GetProfAspirant = (email, stream) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const aspirant = yield _1.default.select([
                    "aspi.id as id",
                    "aspi.first_name as first_name",
                    "aspi.last_name as last_name",
                    "aspi.middle_name as middle_name",
                    "aspi.email as email",
                    "aspi.DOB as DOB",
                    "aspi.gender as gender",
                    "aspi.phone as phone",
                    "aspi.qualification as qualification",
                    "aspi.workplace as workplace",
                    "aspi.years_of_exp as years_of_exp",
                    "aspi.certificate as certificate",
                    // "aspi.year as year",
                    "aspi.paid as paid",
                    "aspi.status as status",
                    'prog.id as programme_id',
                    'prog.name as name',
                    'prog.description as description',
                    'prog.duration as duration',
                    'prog.stream as stream',
                    'prog.open_to_application as open_to_application',
                    'diet.number as diet',
                    'diet.year as diet_year',
                    'diet.is_current as is_current',
                    'diet.session_id as session_id',
                ]).from({ aspi: db_types_1.ETables.PROF_ASPIRANT })
                    .join({ prog: db_types_1.ETables.PROGRAMME }, 'prog.id', 'aspi.programme_id')
                    .join({ diet: db_types_1.ETables.DIET }, 'diet.id', 'aspi.diet_id')
                    .where("email", email).andWhere('prog.stream', stream).first();
                return aspirant;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetAspirant = (id, stream, jamb_reg) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const aspirant = yield _1.default.select([
                    "aspi.*",
                    'prog.id as programme_id',
                    'prog.name as name',
                    'prog.description as description',
                    'prog.duration as duration',
                    'prog.stream as stream',
                    'prog.open_to_application as open_to_application',
                ])
                    .from({ aspi: db_types_1.ETables.ASPIRANT })
                    .join({ prog: db_types_1.ETables.PROGRAMME }, 'prog.id', 'aspi.programme_id')
                    .where('aspi.id', id)
                    // .andWhere('aspi.email', email)
                    // .andWhere("jamb_reg", jamb_reg)
                    .modify((queryBuilder) => {
                    if (stream !== undefined) {
                        queryBuilder.where('prog.stream', stream);
                    }
                    if (jamb_reg !== undefined) {
                        queryBuilder.where('aspi.jamb_reg', jamb_reg);
                    }
                })
                    .first();
                console.log(aspirant);
                aspirant && delete aspirant.password;
                return aspirant;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        // public DBGetAspirant = async (id: number, jamb_reg: string) => {
        //     try {
        //         const aspirant = await knex.raw(
        //             `SELECT *, -password AS password FROM ?? WHERE id = ? AND jamb_reg = ? LIMIT 1`,
        //             [ETables.ASPIRANT, id, jamb_reg]
        //         );
        //         return aspirant.rows[0];
        //     } catch (error) {
        //         return this.catchError(error);
        //     }
        // };
        this.GetStudent = (id, matric_no) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const student = yield _1.default.select([
                    "first_name",
                    "last_name",
                    "email",
                    "id",
                    'adm_no',
                    "matric_no",
                    'stream',
                    'level',
                    'paid'
                ]).from(db_types_1.ETables.STUDENT).where("id", id).andWhere("matric_no", matric_no).first();
                return student;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.IsAdminExist = (id, email) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const admin = yield _1.default.select(["a.*", "r.permissions as permissions"]).from({ a: db_types_1.ETables.ADMIN }).leftJoin({ r: db_types_1.ETables.ADMIN_ROLE }, "r.id", "a.role_id").where("a.id", id).andWhere("a.email", email).first();
                return admin;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
    }
};
AuthAdapter = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [])
], AuthAdapter);
exports.default = AuthAdapter;
