"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const typedi_1 = require("typedi");
const __1 = tslib_1.__importDefault(require(".."));
const studentAdapter_1 = tslib_1.__importDefault(require("../../Database/adapters/studentAdapter"));
const jwt_1 = require("../../Utils/jwt");
const api_response_1 = require("../../Utils/api_response");
const jspdf_1 = require("../../Utils/pdf/jspdf");
let StudentController = class StudentController extends __1.default {
    constructor(studentAdapter) {
        super();
        this.studentAdapter = studentAdapter;
        this.getAcademicSessions = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const sessions = yield this.studentAdapter.DBGetAcademicSessions();
                console.log(sessions);
                return (0, api_response_1.success)(res, sessions);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.login = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { matric_no } = req.body;
                const student = yield this.studentAdapter.DBGetStudent(matric_no);
                const token = (0, jwt_1.generateToken)({ matric_no, id: student.id });
                return (0, api_response_1.success)(res, { token }, "Logged in successfully");
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getProfile = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user, session } = req.body;
                const me = yield this.studentAdapter.DBGetProfile(auth_user.matric_no);
                // me['current_session'] = session.name;
                me.current_session = session.name;
                return (0, api_response_1.success)(res, me);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getResult = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user, session } = req.body;
                const { level, session_id, semester } = req.query;
                let total_obatined_grade = 0;
                let total_units_taken = 0;
                if (!+session_id) {
                    const overall_result = yield this.studentAdapter.DGGetCummulativeResullt(auth_user.id);
                    for (let result of overall_result) {
                        const unit = result.unit;
                        const score = result.grade;
                        const wt = yield this.studentAdapter.DBGetWeight(score);
                        console.log(wt.weight, 'weight');
                        const g = wt.weight * unit;
                        total_obatined_grade += g;
                        total_units_taken += unit;
                    }
                    const GPA = (total_obatined_grade / total_units_taken).toFixed(2);
                    const CGPA = (total_obatined_grade / total_units_taken).toFixed(2);
                    const COD = yield this.studentAdapter.DBGetCOD(+CGPA);
                    return (0, api_response_1.success)(res, { results: overall_result, GPA, CGPA, COD });
                }
                const results = yield this.studentAdapter.DBGetResult(auth_user.id, level, +session_id, semester);
                for (let result of results) {
                    const unit = result.unit;
                    const score = result.grade;
                    const wt = yield this.studentAdapter.DBGetWeight(score);
                    console.log(wt.weight, 'weight');
                    const g = wt.weight * unit;
                    total_obatined_grade += g;
                    total_units_taken += unit;
                }
                console.log(total_obatined_grade, 'total_obatined_grade');
                console.log(total_units_taken, 'total_units_taken');
                const GPA = (total_obatined_grade / total_units_taken).toFixed(2);
                const overall_result = yield this.studentAdapter.DGGetCummulativeResullt(auth_user.id);
                for (let result of overall_result) {
                    const unit = result.unit;
                    const score = result.grade;
                    const wt = yield this.studentAdapter.DBGetWeight(score);
                    console.log(wt.weight, 'weight');
                    const g = wt.weight * unit;
                    total_obatined_grade += g;
                    total_units_taken += unit;
                }
                const CGPA = (total_obatined_grade / total_units_taken).toFixed(2);
                const COD = yield this.studentAdapter.DBGetCOD(+CGPA);
                return (0, api_response_1.success)(res, { results, GPA, CGPA, COD });
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.generateAdmissionLetter = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user } = req.body;
                const output = (0, jspdf_1.genAdmissionLetterPDF)(auth_user.first_name, auth_user.stream, new Date());
                // Set the content type to application/pdf
                res.setHeader('Content-Type', 'application/pdf');
                // Suggest download file name
                res.setHeader('Content-Disposition', `attachment; filename=admission-letter-${auth_user.first_name.replace(/\s+/g, '-')}.pdf`);
                // Send the PDF as a buffer
                res.send(Buffer.from(output));
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getExamSlip = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user } = req.body;
                const output = (0, jspdf_1.generateExamSlip)(auth_user);
                res.setHeader('Content-Type', 'application/pdf');
                res.setHeader('Content-Disposition', `attachment; filename=Exam_slip-${auth_user.first_name.replace(/\s+/g, '-')}.pdf`);
                res.send(Buffer.from(output));
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
    }
};
StudentController = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__param(0, (0, typedi_1.Inject)()),
    tslib_1.__metadata("design:paramtypes", [studentAdapter_1.default])
], StudentController);
;
exports.default = StudentController;
