"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const typedi_1 = require("typedi");
const __1 = tslib_1.__importDefault(require(".."));
const axios_1 = tslib_1.__importDefault(require("axios"));
const bcryptjs_1 = tslib_1.__importDefault(require("bcryptjs"));
const node_forge_1 = tslib_1.__importDefault(require("node-forge"));
const api_response_1 = require("../../Utils/api_response");
const feeAdapter_1 = tslib_1.__importDefault(require("../../Database/adapters/feeAdapter"));
const factory_1 = require("../../Utils/factory");
const pay_refAdapter_1 = tslib_1.__importDefault(require("../../Database/adapters/pay_refAdapter"));
const mailer_1 = require("../../Utils/mailer");
const nodemailer_1 = require("../../Utils/mailer/nodemailer");
const studentAdapter_1 = tslib_1.__importDefault(require("../../Database/adapters/studentAdapter"));
const aspirantAdapter_1 = tslib_1.__importDefault(require("../../Database/adapters/aspirantAdapter"));
const enum_1 = require("../../types/enum");
let FeeController = class FeeController extends __1.default {
    constructor(feeAdapter, pay_refAdapter, studentAdapter, aspirantAdapter) {
        super();
        this.feeAdapter = feeAdapter;
        this.pay_refAdapter = pay_refAdapter;
        this.studentAdapter = studentAdapter;
        this.aspirantAdapter = aspirantAdapter;
        this.payProfFormFee = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { first_name, last_name, middle_name, email, phone, session } = req.body;
                const { stream } = req.params;
                const { split } = req.query;
                let fee = yield this.feeAdapter.DBGetProfFormFee(session.id);
                let amount = 0;
                // const totalFee = fee.amount + calculateCharges(fee.amount);
                if (split && fee.upfront) {
                    // calculate 60% of it
                    // amount = 0.6 * totalFee * 100;
                    amount = ((0.6 * fee.amount) + (0, factory_1.calculateCharges)(fee.amount)) * 100;
                    fee = Object.assign(Object.assign({}, fee), { amount_paid: amount, amount_due: fee.amount, balance: fee.amount - amount });
                }
                else {
                    // amount = totalFee * 100;
                    amount = (fee.amount + (0, factory_1.calculateCharges)(fee.amount)) * 100;
                }
                const transactionID = (0, factory_1.generateTransactionID)();
                const metadata = {
                    fee,
                    customer: { first_name, last_name, middle_name, email, phone },
                    stream,
                    invoice_type: enum_1.Invoice_Type.FORM
                };
                const payment = yield (0, axios_1.default)({
                    method: 'POST',
                    url: `https://api.paystack.co/transaction/initialize`,
                    headers: {
                        "Content-Type": "application/json",
                        Authorization: `Bearer ${process.env.PAYSTACK_SECRET_KEY}`
                    },
                    // data: { email, amount: Math.ceil(amount), reference: transactionID, metadata, callback_url: `${process.env.TNM_CLIENT_URL}/aspirant/professional/fee/application_fee/verify?fee_id=${fee.id}&stream=${stream}` },
                    data: { email, amount: Math.ceil(amount), reference: transactionID, metadata, callback_url: `${process.env.TNM_CLIENT_URL}/aspirant/professional/login?msg=Kindly fllow the instructions you received in teh mail to continue` },
                });
                // return success(res, { url: payment.data.data.authorization_url, ref: transactionID, fee_id: fee.id });
                return (0, api_response_1.success)(res, { url: '#', ref: transactionID, fee_id: fee.id });
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.processFormPayment = (session, amount, metadata, reference) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { email, first_name, last_name, middle_name, DOB, phone } = metadata.customer;
                console.log(last_name.toLowerCase(), 'paswoord forlogin');
                const salt = yield bcryptjs_1.default.genSalt(10);
                const password = bcryptjs_1.default.hashSync(last_name.toLowerCase(), salt);
                const new_aspirant = yield this.aspirantAdapter.DBCreateProfAspirant({ email, first_name, last_name, password, middle_name, phone }, metadata.stream, session.id, session.current_diet.id);
                console.log(new_aspirant, 'new aspirant');
                yield this.feeAdapter.DBCreateAspirantFee(new_aspirant, metadata.fee, amount / 100, metadata.stream, reference, session);
                (0, nodemailer_1.sendMail)({ to: email, type: 'html', subject: 'Apllication Request', content: `<div> Kindly login to continue, use your email as the username and surname as the password </div>` });
            }
            catch (error) {
                throw error;
            }
        });
        this.verifyFormPayment = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                // const { email, first_name, last_name, DOB, session } = req.body;
                const { session, fee_id } = req.body;
                const { stream } = req.params;
                const { reference } = req.query;
                const verify = yield (0, axios_1.default)({
                    method: 'GET',
                    url: `https://api.paystack.co/transaction/verify/${reference}`,
                    headers: {
                        "Content-Type": "application/json",
                        Authorization: `Bearer ${process.env.PAYSTACK_SECRET_KEY}`
                    },
                });
                const { status, amount, gateway_response, requested_amount, channel, metadata, message } = verify.data.data;
                console.log(metadata, 'metadata');
                console.log(status, 'status');
                if (status !== 'success')
                    return (0, api_response_1.badRequest)(res, gateway_response);
                if (amount !== requested_amount)
                    throw new Error('Invalid payment');
                const { email, first_name, last_name, middle_name, DOB, phone } = metadata.customer;
                const ref = reference;
                yield this.pay_refAdapter.DBSavePaymentRef(email, ref, metadata.fee);
                const replacements = {
                    userName: `${first_name} ${last_name}`,
                    companyName: process.env.COMPANY_NAME || 'TNM Media Academy',
                    orderID: ref,
                    orderDate: new Date(),
                    paymentMethod: channel,
                    shippingAddress: "",
                    deliveryDate: "3 days",
                    contactInfo: 'tnm_contact',
                    supportLink: process.env.SUPPORT_LINK
                };
                // Get email content with dynamic data
                const emailContent = (0, mailer_1.generateContent)('/mails/receipt.html', replacements);
                (0, nodemailer_1.sendMail)({ to: email, type: 'html', subject: 'Please verify your email', content: emailContent });
                // crete sudent_fee data
                if (status) {
                    console.log(last_name.toLowerCase(), 'paswoord forlogin');
                    const salt = yield bcryptjs_1.default.genSalt(10);
                    const password = bcryptjs_1.default.hashSync(last_name.toLowerCase(), salt);
                    const new_aspirant = yield this.aspirantAdapter.DBCreateProfAspirant({ email, first_name, last_name, password, middle_name, phone }, stream, session.id, session.current_diet.id);
                    console.log(new_aspirant, 'new aspirant');
                    yield this.feeAdapter.DBCreateAspirantFee(new_aspirant, metadata.fee, amount / 100, stream, ref, session);
                }
                return (0, api_response_1.success)(res, status, 'Kindly login to continue, use your email as the username and surname as the password');
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        // NID
        this.getPUTMEFee = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { session } = req.body;
                const fee = yield this.feeAdapter.DBGetPUTMFee(session.id);
                fee.charges = (0, factory_1.calculateCharges)(fee.amount);
                // return success(res, {fee, charges: calculateCharges(fee.amount)});
                return (0, api_response_1.success)(res, fee);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.processPUTMEPayment = (session, amount, metadata, reference) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { email, first_name, last_name, middle_name, DOB, phone, gender, jamb_reg, o_level_mimetype, jamb_result_mimetype, olevel_file_path, jamb_result_file_path } = metadata.customer;
                // const fileData = fileStore.get(email);
                const salt = yield bcryptjs_1.default.genSalt(10);
                const password = bcryptjs_1.default.hashSync(last_name.toLowerCase(), salt);
                const reg_no = yield (0, factory_1.generateApplicationNo)();
                const new_aspirant = yield this.aspirantAdapter.DBPUTMERegistration({
                    first_name, last_name, middle_name, email, phone, password, DOB, gender, jamb_reg,
                    // o_level: Buffer.from(fileData.o_level, 'base64'), o_level_mimetype,
                    // jamb_result: Buffer.from(fileData.jamb_result, 'base64'), jamb_result_mimetype
                    // o_level: fileData.o_level, o_level_mimetype,
                    // jamb_result: fileData.jamb_result, jamb_result_mimetype
                    o_level_path: olevel_file_path, o_level_mimetype,
                    jamb_result_path: jamb_result_file_path, jamb_result_mimetype
                }, reg_no, +metadata.programme_id, session);
                console.log(new_aspirant, 'new aspirant');
                yield this.feeAdapter.DBCreateAspirantFee(new_aspirant, metadata.fee, amount / 100, metadata.stream, reference, session);
                factory_1.fileStore.delete(email);
                (0, nodemailer_1.sendMail)({ to: email, type: 'html', subject: 'PUTME Registration', content: `<div> Thanks for your interest in TNM Media Academy, kindly login to continue using your jamb number and surname as the password </div> ` });
            }
            catch (error) {
                throw error;
            }
        });
        this.verifyPUTMEPayment = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { session, fee_id } = req.body;
                const { reference } = req.query;
                const verify = yield (0, axios_1.default)({
                    method: 'GET',
                    url: `https://api.paystack.co/transaction/verify/${reference}`,
                    headers: {
                        "Content-Type": "application/json",
                        Authorization: `Bearer ${process.env.PAYSTACK_SECRET_KEY}`
                    },
                });
                const { status, amount, gateway_response, requested_amount, channel, metadata, message } = verify.data.data;
                console.log(metadata, 'metadata');
                // const { email, first_name, last_name, middle_name, DOB, phone, gender, jamb_reg, o_level, o_level_mimetype, jamb_result, jamb_result_mimetype } = metadata.customer
                const { email, first_name, last_name, middle_name, DOB, phone, gender, jamb_reg, o_level_mimetype, jamb_result_mimetype } = metadata.customer;
                const fileData = factory_1.fileStore.get(email);
                console.log(status, 'status');
                if (status !== 'success')
                    return (0, api_response_1.badRequest)(res, gateway_response);
                if (amount !== requested_amount)
                    throw new Error('Invalid payment');
                const ref = reference;
                yield this.pay_refAdapter.DBSavePaymentRef(email, ref, metadata.fee);
                const replacements = {
                    userName: `${first_name} ${last_name}`,
                    companyName: process.env.COMPANY_NAME || 'TNM Media Academy',
                    orderID: ref,
                    orderDate: new Date(),
                    paymentMethod: channel,
                    shippingAddress: "",
                    deliveryDate: "3 days",
                    contactInfo: 'tnm_contact',
                    supportLink: process.env.SUPPORT_LINK
                };
                // Get email content with dynamic data
                const emailContent = (0, mailer_1.generateContent)('/mails/receipt.html', replacements);
                (0, nodemailer_1.sendMail)({ to: email, type: 'html', subject: 'Please verify your email', content: emailContent });
                // crete sudent_fee data
                if (status) {
                    const salt = yield bcryptjs_1.default.genSalt(10);
                    const password = bcryptjs_1.default.hashSync(last_name.toLowerCase(), salt);
                    const reg_no = yield (0, factory_1.generateApplicationNo)();
                    // const new_aspirant = await this.aspirantAdapter.DBPUTMERegistration({
                    //     first_name, last_name, middle_name, email, phone, password, DOB, gender, jamb_reg,
                    //     // o_level: Buffer.from(fileData.o_level, 'base64'), o_level_mimetype,
                    //     // jamb_result: Buffer.from(fileData.jamb_result, 'base64'), jamb_result_mimetype
                    //     o_level: fileData.o_level, o_level_mimetype,
                    //     jamb_result: fileData.jamb_result, jamb_result_mimetype
                    // }, reg_no, metadata.programme_id, session)
                    // console.log(new_aspirant, 'new aspirant');
                    // await this.feeAdapter.DBCreateAspirantFee(new_aspirant, metadata.fee, amount / 100, metadata.stream, ref, session);
                    factory_1.fileStore.delete(email);
                }
                return (0, api_response_1.success)(res, status);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        // PART
        this.getPartApplicationFee = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { session } = req.body;
                const fee = yield this.feeAdapter.DBGetPartApplicationFee(session.id);
                fee.charges = (0, factory_1.calculateCharges)(fee.amount);
                // return success(res, {fee, charges: calculateCharges(fee.amount)});
                return (0, api_response_1.success)(res, fee);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.processPartApplicationPayment = (session, amount, metadata, reference) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { email, first_name, last_name, middle_name, DOB, phone, gender, state_of_origin, lga, address, manual_o_level, o_level_mimetype, passport_mimetype, olevel_file_path, passport_file_path } = metadata.customer;
                // const fileData = fileStore.get(email);
                const salt = yield bcryptjs_1.default.genSalt(10);
                const password = bcryptjs_1.default.hashSync(last_name.toLowerCase(), salt);
                const reg_no = yield (0, factory_1.generateApplicationNo)();
                const new_aspirant = yield this.aspirantAdapter.DBPartApplication({
                    first_name, last_name, middle_name, email, phone, password, DOB, gender, state_of_origin, lga, address, manual_o_level,
                    // o_level: fileData.o_level, o_level_mimetype,
                    // passport: fileData.passport, passport_mimetype
                    o_level_path: olevel_file_path, o_level_mimetype,
                    passport_path: passport_file_path, passport_mimetype
                }, reg_no, +metadata.programme_id, session);
                console.log(new_aspirant, 'new aspirant');
                yield this.feeAdapter.DBCreateAspirantFee(new_aspirant, metadata.fee, amount / 100, metadata.stream, reference, session);
                factory_1.fileStore.delete(email);
                (0, nodemailer_1.sendMail)({ to: email, type: 'html', subject: 'PUTME Registration', content: `<div> Thanks for your interest in TNM Media Academy, kindly login to continue using your email and surname as the password </div> ` });
            }
            catch (error) {
                throw error;
            }
        });
        // BOTH
        this.getIDCardFee = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { session } = req.body;
                const { auth_user } = req.body;
                // const category = auth_user.stream ? Category.PROFESSIONAL : Category.STANDARD
                const category = Object.values(enum_1.NID_Stream).includes(auth_user.stream) ? enum_1.Category.NID : enum_1.Category.PROFESSIONAL;
                const fee = yield this.feeAdapter.DBGetIDCardFee(session.id, category);
                return (0, api_response_1.success)(res, fee);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getAcceptanceFee = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { session } = req.body;
                const { auth_user } = req.body;
                // const category = auth_user.stream ? Category.PROFESSIONAL : Category.STANDARD
                const category = (auth_user.stream === enum_1.PROF_Stream.BASIC || auth_user.stream === enum_1.PROF_Stream.ADVANCED) ? enum_1.Category.PROFESSIONAL : auth_user.stream === enum_1.NID_Stream.FULL ? enum_1.Category.FULL : enum_1.Category.PART;
                const fee = yield this.feeAdapter.DBGetAcceptanceFee(session.id, category);
                return (0, api_response_1.success)(res, fee);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.payAcceptanceFee = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            var _a;
            try {
                const { auth_user, session } = req.body;
                const { email, first_name, last_name } = auth_user;
                const { programme_id, stream } = req.params;
                const { split } = req.query;
                // const category = auth_user.stream ? Category.PROFESSIONAL : Category.STANDARD
                const category = (auth_user.stream === enum_1.PROF_Stream.BASIC || auth_user.stream === enum_1.PROF_Stream.ADVANCED) ? enum_1.Category.PROFESSIONAL : auth_user.stream === enum_1.NID_Stream.FULL ? enum_1.Category.FULL : enum_1.Category.PART;
                let fee = yield this.feeAdapter.DBGetAcceptanceFee(session.id, category);
                // let receipt: { [key: string]: object } = {}; 
                let amount;
                const transactionID = (0, factory_1.generateTransactionID)();
                fee[transactionID] = transactionID;
                if (split && fee.upfront) {
                    // calculate 60% of it
                    amount = ((0.6 * fee.amount) + (0, factory_1.calculateCharges)(fee.amount)) * 100;
                    fee = Object.assign(Object.assign({}, fee), { amount_paid: amount, amount_due: fee.amount, balance: fee.amount - amount });
                }
                else {
                    amount = (fee.amount + (0, factory_1.calculateCharges)(fee.amount)) * 100;
                }
                delete auth_user.o_level;
                delete auth_user.jamb_result;
                delete auth_user.adm_letter;
                const metadata = {
                    fee,
                    customer: { first_name, last_name, email },
                    stream: (_a = auth_user.stream) !== null && _a !== void 0 ? _a : stream,
                    invoice_type: enum_1.Invoice_Type.ACCEPTANCE,
                    auth_user
                };
                // const callback_url = stream ? `${process.env.TNM_CLIENT_URL}/aspirant/professional/fee/acceptance_fee/verify?fee_id=${fee.id}&stream=${stream}` :
                //     `${process.env.TNM_CLIENT_URL}/aspirant/nid/fee/acceptance_fee/verify?fee_id=${fee.id}`
                const callback_url = stream ? `${process.env.TNM_CLIENT_URL}/aspirant/professional` :
                    `${process.env.TNM_CLIENT_URL}/aspirant/nid`;
                const payment = yield (0, axios_1.default)({
                    method: 'POST',
                    url: `https://api.paystack.co/transaction/initialize`,
                    headers: {
                        "Content-Type": "application/json",
                        Authorization: `Bearer ${process.env.PAYSTACK_SECRET_KEY}`
                    },
                    data: { email, amount: Math.ceil(amount), reference: transactionID, metadata, callback_url },
                });
                console.log(transactionID);
                // return success(res, { url: payment.data.data.authorization_url, ref: transactionID, fee_id: fee.id });
                return (0, api_response_1.success)(res, { url: '#', ref: transactionID, fee_id: fee.id });
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.processAcceptanceFee = (session, amount, metadata, reference) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user, fee, stream } = metadata;
                yield this.feeAdapter.DBCreateAspirantFee(auth_user.id, fee, amount / 100, stream, reference, session);
                yield this.aspirantAdapter.DBUpdateAcceptancePaymentStatus(auth_user.id, auth_user.jamb_reg);
            }
            catch (error) {
                throw error;
            }
        });
        this.verifyAcceptanceFee = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { session, auth_user } = req.body;
                const { stream } = req.params;
                const { reference } = req.query;
                const verify = yield (0, axios_1.default)({
                    method: 'GET',
                    url: `https://api.paystack.co/transaction/verify/${reference}`,
                    headers: {
                        "Content-Type": "application/json",
                        Authorization: `Bearer ${process.env.PAYSTACK_SECRET_KEY}`
                    },
                });
                const { status, amount, gateway_response, requested_amount, channel, metadata, message } = verify.data.data;
                console.log(metadata, 'metadata');
                const { email, first_name, last_name, DOB } = metadata.customer;
                console.log(status, 'status', 'acceptance_fee');
                if (status !== 'success')
                    return (0, api_response_1.badRequest)(res, gateway_response);
                if (amount !== requested_amount)
                    throw new Error('Invalid payment');
                const ref = reference;
                yield this.pay_refAdapter.DBSavePaymentRef(email, ref, metadata.fee);
                const replacements = {
                    userName: `${first_name} ${last_name}`,
                    companyName: process.env.COMPANY_NAME || 'TNM Media Academy',
                    orderID: ref,
                    orderDate: new Date(),
                    paymentMethod: channel,
                    shippingAddress: "",
                    deliveryDate: "3 days",
                    contactInfo: 'tnm_contact',
                    supportLink: process.env.SUPPORT_LINK
                };
                // Get email content with dynamic data
                const emailContent = (0, mailer_1.generateContent)('/mails/receipt.html', replacements);
                (0, nodemailer_1.sendMail)({ to: email, type: 'html', subject: 'TNM Acceptance fee', content: emailContent });
                // crete sudent_fee data and update aspi data
                if (status) {
                    yield this.feeAdapter.DBCreateAspirantFee(auth_user.id, metadata.fee, amount / 100, stream, ref, session);
                    yield this.aspirantAdapter.DBUpdateAcceptancePaymentStatus(auth_user.id, auth_user.jamb_reg);
                }
                return (0, api_response_1.success)(res, status);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getSchoolFee = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user, session } = req.body;
                const { split } = req.query;
                // const stream = auth_user.stream || Stream.STANDARD
                const fee = yield this.feeAdapter.DBGetSchoolFee(auth_user.stream, session.id);
                const spt = split === 'true';
                if (spt && fee.upfront) {
                    console.log('should');
                    fee.amount = 60 / 100 * fee.amount;
                }
                return (0, api_response_1.success)(res, fee);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.paySchoolFeeAndIDCard = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            var _b, _c;
            try {
                const { auth_user, session } = req.body;
                const { email, first_name, last_name, DOB } = auth_user;
                const { programme_id, stream } = req.params;
                const { split } = req.query;
                // const strm = stream || Stream.STANDARD
                // const category = (stream == 'basic' || stream == 'advanced') ? Category.PROFESSIONAL : Category.STANDARD
                const category = Object.values(enum_1.NID_Stream).includes(auth_user.stream) ? enum_1.Category.NID : enum_1.Category.PROFESSIONAL;
                let fee = yield this.feeAdapter.DBGetSchoolFee((_b = auth_user.stream) !== null && _b !== void 0 ? _b : stream, session.id);
                const card_fee = yield this.feeAdapter.DBGetIDCardFee(session.id, category);
                // let receipt: { [key: string]: object } = {};
                let amount;
                const transactionID = (0, factory_1.generateTransactionID)();
                fee[transactionID] = transactionID;
                if (split && fee.upfront) {
                    // calculate 60% of it;
                    amount = 0.6 * fee.amount;
                    fee = Object.assign(Object.assign({}, fee), { amount_paid: amount, amount_due: fee.amount, balance: fee.amount - amount });
                }
                else {
                    amount = fee.amount;
                }
                amount += card_fee.amount;
                amount = (amount + (0, factory_1.calculateCharges)(amount)) * 100;
                delete auth_user.o_level;
                delete auth_user.jamb_result;
                delete auth_user.adm_letter;
                const metadata = {
                    fee,
                    card_fee,
                    customer: { first_name, last_name, email, DOB },
                    stream: (_c = auth_user.stream) !== null && _c !== void 0 ? _c : stream,
                    invoice_type: enum_1.Invoice_Type.TUITION,
                    auth_user
                };
                const fee_ids = [fee.id, card_fee.id];
                // const callback_url = stream ? `${process.env.TNM_CLIENT_URL}/aspirant/professional/fee/school_fee/verify?fee_ids=${fee_ids}&stream=${stream}` :
                //     `${process.env.TNM_CLIENT_URL}/aspirant/nid/fee/school_fee/verify?fee_ids=${fee_ids}`
                const callback_url = stream ? `${process.env.TNM_CLIENT_URL}/` :
                    `${process.env.TNM_CLIENT_URL}/aspirant/nid`;
                const payment = yield (0, axios_1.default)({
                    method: 'POST',
                    url: `https://api.paystack.co/transaction/initialize`,
                    headers: {
                        "Content-Type": "application/json",
                        Authorization: `Bearer ${process.env.PAYSTACK_SECRET_KEY}`
                    },
                    data: { email, amount: Math.ceil(amount), reference: transactionID, metadata, callback_url },
                });
                console.log(transactionID);
                // return success(res, { url: payment.data.data.authorization_url, ref: transactionID, fee_id: fee.id });
                return (0, api_response_1.success)(res, { url: '#', ref: transactionID, fee_id: fee.id });
                // return success(res, { url: payment.data.data.authorization_url, ref: transactionID, fee_ids });
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.processTution = (session, amount, metadata, reference) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user, stream, customer } = metadata;
                const { email, first_name, last_name, DOB } = customer;
                // const strm = metadata.stream || Stream.STANDARD
                const programme = yield this.studentAdapter.getProgrammeByStream(stream);
                const paid = metadata.fee.amount_due === metadata.fee.amount_paid;
                const diet = yield this.studentAdapter.getDietById(session.current_diet.id);
                const adm_no = yield (0, factory_1.generateRegNo)(programme, diet);
                const password = yield (0, factory_1.encodeLastName)(last_name);
                // const level = stream != Stream.STANDARD ? Level._13 : Level._100
                const level = Object.values(enum_1.NID_Stream).includes(auth_user.stream) ? enum_1.Level._100 : enum_1.Level._13;
                const student = yield this.studentAdapter.DBCreateStudent(auth_user, password, adm_no, paid, level, diet.id);
                // await this.feeAdapter.DBCreateStudentFee(student, metadata.fee, (amount / 100) - metadata.card_fee.amount, strm, reference, programme.id, session, false);
                yield this.feeAdapter.DBCreateStudentFee(student, metadata.fee, metadata.fee.amount - metadata.card_fee.amount, stream, reference, programme.id, session, false);
                yield this.feeAdapter.DBCreateStudentFee(student, metadata.card_fee, metadata.card_fee.amount, stream, reference, programme.id, session, false);
                // transfer all fee table to student_fee table
                // delete user from aspirant table
                yield this.aspirantAdapter.DBTransferReceipt(auth_user.id, student, stream);
                // await this.aspirantAdapter.DBRemoveAspirant(auth_user.id, auth_user.email, stream, student);
                yield this.aspirantAdapter.DBCreateEnrollmentV2(auth_user.id, {
                    stream: auth_user.stream,
                    entry_session: session.id,
                    diet_id: diet.id,
                    programme_id: programme.id,
                    student_id: student,
                    session_id: session.id
                }, programme.duration);
                console.log({ to: email, type: 'html', subject: 'Congratulations!!', content: `Your admission number is ${adm_no}. Kindly login with the last part of the admission number as the matric number and your surname as the passwoord` });
                (0, nodemailer_1.sendMail)({ to: email, type: 'html', subject: 'Congratulations!!', content: `Your admission number is ${adm_no}. Kindly login with the last part of the admission number as the matric number and your surname as the passwoord` });
            }
            catch (error) {
                throw error;
            }
        });
        this.verifySchoolFeeAndIDCard = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { session, auth_user } = req.body;
                const { stream } = req.params;
                const { reference } = req.query;
                const verify = yield (0, axios_1.default)({
                    method: 'GET',
                    url: `https://api.paystack.co/transaction/verify/${reference}`,
                    headers: {
                        "Content-Type": "application/json",
                        Authorization: `Bearer ${process.env.PAYSTACK_SECRET_KEY}`
                    },
                });
                const { status, amount, gateway_response, requested_amount, channel, metadata, message } = verify.data.data;
                console.log(metadata, 'metadata');
                const { email, first_name, last_name, DOB } = metadata.customer;
                console.log(status, 'status', 'school_fee');
                if (status !== 'success')
                    return (0, api_response_1.badRequest)(res, gateway_response);
                if (amount !== requested_amount)
                    throw new Error('Invalid payment');
                const ref = reference;
                yield this.pay_refAdapter.DBSavePaymentRef(email, ref, { fee: metadata.fee, card_fee: metadata.card_fee });
                const replacements = {
                    userName: `${first_name} ${last_name}`,
                    companyName: process.env.COMPANY_NAME || 'TNM Media Academy',
                    orderID: ref,
                    orderDate: new Date(),
                    paymentMethod: channel,
                    shippingAddress: "",
                    deliveryDate: "3 days",
                    contactInfo: 'tnm_contact',
                    supportLink: process.env.SUPPORT_LINK
                };
                // Get email content with dynamic data
                const emailContent = (0, mailer_1.generateContent)('/mails/receipt.html', replacements);
                (0, nodemailer_1.sendMail)({ to: email, type: 'html', subject: 'TNM Acceptance fee', content: emailContent });
                // crete sudent_fee data
                if (status) {
                    // const strm = stream || Stream.STANDARD
                    const programme = yield this.studentAdapter.getProgrammeByStream(stream);
                    const paid = metadata.fee.amount_due === metadata.fee.amount_paid;
                    const diet = yield this.studentAdapter.getDietById(session.current_diet.id);
                    const adm_no = yield (0, factory_1.generateRegNo)(programme, diet);
                    const password = yield (0, factory_1.encodeLastName)(last_name);
                    const level = Object.values(enum_1.NID_Stream).includes(auth_user.stream) ? enum_1.Level._100 : enum_1.Level._13;
                    const student_id = yield this.studentAdapter.DBCreateStudent(auth_user, password, adm_no, paid, diet.id);
                    // await this.feeAdapter.DBCreateAspirantFee(auth_user.id, metadata.fee, metadata.fee.amount, strm, ref, session);
                    // await this.feeAdapter.DBCreateAspirantFee(auth_user.id, metadata.card_fee, metadata.card_fee.amount, strm, ref, session);
                    // await this.feeAdapter.DBCreateStudentFee(student_id, metadata.fee, (amount / 100) - metadata.card_fee.amount, strm, ref, programme.id, session, false);
                    yield this.feeAdapter.DBCreateStudentFee(student_id, metadata.fee, metadata.fee.amount - metadata.card_fee.amount, stream, ref, programme.id, session, false);
                    yield this.feeAdapter.DBCreateStudentFee(student_id, metadata.card_fee, metadata.card_fee.amount, stream, ref, programme.id, session, false);
                    // transfer all fee table to student_fee table
                    // delete user from aspirant table
                    console.log({ to: email, type: 'html', subject: 'Congratulations!!', content: `Your admission number is ${adm_no}. Kindly login with the last part of the admission number as the matric number and your surname as the passwoord` });
                    (0, nodemailer_1.sendMail)({ to: email, type: 'html', subject: 'Congratulations!!', content: `Your admission number is ${adm_no}. Kindly login with the last part of the admission number as the matric number and your surname as the passwoord` });
                }
                return (0, api_response_1.success)(res, status);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.payAcceptanceSchoolFeeAndIDCard = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            var _d, _e;
            try {
                const { auth_user, session } = req.body;
                const { email, first_name, last_name, DOB } = auth_user;
                const { programme_id, stream } = req.params;
                const { split } = req.query;
                // const strm = stream || Stream.STANDARD
                let fee = yield this.feeAdapter.DBGetSchoolFee((_d = auth_user.stream) !== null && _d !== void 0 ? _d : stream, session.id);
                // const category = (stream == 'basic' || stream == 'advanced') ? Category.PROFESSIONAL : Category.STANDARD
                // const category = Object.values(NID_Stream).includes(auth_user.stream) ? Category.NID : Category.PROFESSIONAL;
                // const category = (auth_user.stream === PROF_Stream.BASIC || auth_user.stream === PROF_Stream.ADVANCED) ? Category.PROFESSIONAL : auth_user.stream === NID_Stream.FULL ?  Category.FULL : Category.PART
                const accp_cat = (auth_user.stream === enum_1.PROF_Stream.BASIC || auth_user.stream === enum_1.PROF_Stream.ADVANCED) ? enum_1.Category.PROFESSIONAL : auth_user.stream === enum_1.NID_Stream.FULL ? enum_1.Category.FULL : enum_1.Category.PART;
                const card_fee = yield this.feeAdapter.DBGetIDCardFee(session.id, Object.values(enum_1.NID_Stream).includes(auth_user.stream) ? enum_1.Category.NID : enum_1.Category.PROFESSIONAL);
                const acceptance_fee = yield this.feeAdapter.DBGetAcceptanceFee(session.id, accp_cat);
                // let receipt: { [key: string]: object } = {};
                let amount;
                const transactionID = (0, factory_1.generateTransactionID)();
                fee[transactionID] = transactionID;
                if (split && fee.upfront) {
                    // calculate 60% of it;
                    // amount = 60 / 100 * (fee.amount *  100);
                    amount = 0.6 * fee.amount;
                    fee = Object.assign(Object.assign({}, fee), { amount_paid: amount, amount_due: fee.amount, balance: fee.amount - amount });
                }
                else {
                    amount = fee.amount;
                }
                // amount += (card_fee.amount * 100)
                amount = amount + card_fee.amount + acceptance_fee.amount;
                amount = (amount + (0, factory_1.calculateCharges)(amount)) * 100;
                delete auth_user.o_level;
                delete auth_user.jamb_result;
                delete auth_user.adm_letter;
                const metadata = {
                    fee,
                    card_fee,
                    acceptance_fee,
                    customer: { first_name, last_name, email, DOB },
                    stream: (_e = auth_user.stream) !== null && _e !== void 0 ? _e : stream,
                    invoice_type: enum_1.Invoice_Type.ACCEPTANCE_TUTION,
                    auth_user
                };
                const fee_ids = [fee.id, card_fee.id, acceptance_fee.id];
                // const callback_url = stream ? `${process.env.TNM_CLIENT_URL}/aspirant/professional/fee/all_fee/verify?fee_ids=${fee_ids}&stream=${stream}` :
                //     `${process.env.TNM_CLIENT_URL}/aspirant/nid/fee/all_fee/verify?fee_ids=${fee_ids}`
                const callback_url = stream ? `${process.env.TNM_CLIENT_URL}/` :
                    `${process.env.TNM_CLIENT_URL}/`;
                const payment = yield (0, axios_1.default)({
                    method: 'POST',
                    url: `https://api.paystack.co/transaction/initialize`,
                    headers: {
                        "Content-Type": "application/json",
                        Authorization: `Bearer ${process.env.PAYSTACK_SECRET_KEY}`
                    },
                    data: { email, amount: Math.ceil(amount), reference: transactionID, metadata, callback_url },
                });
                console.log(transactionID);
                // return success(res, { url: payment.data.data.authorization_url, ref: transactionID, fee_id: fee.id });
                // return success(res, { url: payment.data.data.authorization_url, ref: transactionID, fee_ids });
                return (0, api_response_1.success)(res, { url: '#', ref: transactionID, fee_ids });
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.processAcceptanceAndTutionFee = (session, amount, metadata, reference) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user, stream, customer } = metadata;
                const { email, first_name, last_name, DOB } = customer;
                // const strm = stream || Stream.STANDARD;
                const paid = metadata.fee.amount_due === metadata.fee.amount_paid;
                const programme = yield this.studentAdapter.getProgrammeByStream(stream);
                const diet = yield this.studentAdapter.getDietById(session.current_diet.id);
                const adm_no = yield (0, factory_1.generateRegNo)(programme, diet);
                const password = yield (0, factory_1.encodeLastName)(last_name);
                const level = stream == enum_1.Stream.BASIC || stream == enum_1.Stream.ADVANCED ? enum_1.Level._13 : enum_1.Level._100;
                const student = yield this.studentAdapter.DBCreateStudent(auth_user, password, adm_no, paid, level);
                // await this.feeAdapter.DBCreateAspirantFee(auth_user.id, metadata.fee, metadata.fee.amount, strm, ref, session);
                // await this.feeAdapter.DBCreateAspirantFee(auth_user.id, metadata.card_fee, metadata.card_fee.amount, strm, ref, session);
                // await this.feeAdapter.DBCreateAspirantFee(auth_user.id, metadata.acceptance_fee, metadata.acceptance_fee.amount, strm, ref, session);
                const amount_paid = metadata.fee.amount - (Number(metadata.card_fee.amount) + Number(metadata.acceptance_fee.amount));
                // const amount_paid = (amount / 100) - (Number(metadata.card_fee.amount) + Number(metadata.acceptance_fee.amount))
                yield this.feeAdapter.DBCreateStudentFee(student, metadata.fee, amount_paid, stream, reference, programme.id, session, false);
                yield this.feeAdapter.DBCreateStudentFee(student, metadata.card_fee, metadata.card_fee.amount, stream, reference, programme.id, session, false);
                yield this.feeAdapter.DBCreateStudentFee(student, metadata.acceptance_fee, metadata.acceptance_fee.amount, stream, reference, programme.id, session, false);
                // transfer all fee table to student_fee table;
                yield this.aspirantAdapter.DBTransferReceipt(auth_user.id, student, stream);
                // await this.aspirantAdapter.DBRemoveAspirant(auth_user.id, auth_user.email, stream, student);
                yield this.aspirantAdapter.DBCreateEnrollmentV2(auth_user.id, {
                    stream: auth_user.stream,
                    entry_session: session.id,
                    diet_id: diet.id,
                    programme_id: programme.id,
                    student_id: student,
                    session_id: session.id
                }, programme.duration);
                (0, nodemailer_1.sendMail)({ to: email, type: 'html', subject: 'Congratulations!!', content: `Your admission number is ${adm_no}. Kindly login with the last part of the admission number as the matric number and your surname as the passwoord` });
            }
            catch (error) {
                throw error;
            }
        });
        this.verifyAcceptanceSchoolFeeAndIDCard = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { session, auth_user } = req.body;
                const { stream } = req.params;
                const { reference } = req.query;
                const verify = yield (0, axios_1.default)({
                    method: 'GET',
                    url: `https://api.paystack.co/transaction/verify/${reference}`,
                    headers: {
                        "Content-Type": "application/json",
                        Authorization: `Bearer ${process.env.PAYSTACK_SECRET_KEY}`
                    },
                });
                const { status, amount, gateway_response, requested_amount, channel, metadata, message } = verify.data.data;
                console.log(metadata, 'metadata');
                const { email, first_name, last_name, DOB } = metadata.customer;
                console.log(status, 'status', 'all_fee');
                if (status !== 'success')
                    return (0, api_response_1.badRequest)(res, gateway_response);
                if (amount !== requested_amount)
                    throw new Error('Invalid payment');
                const ref = reference;
                yield this.pay_refAdapter.DBSavePaymentRef(email, ref, { fee: metadata.fee, card_fee: metadata.card_fee, acceptance_fee: metadata.acceptance_fee });
                const replacements = {
                    userName: `${first_name} ${last_name}`,
                    companyName: process.env.COMPANY_NAME || 'TNM Media Academy',
                    orderID: ref,
                    orderDate: new Date(),
                    paymentMethod: channel,
                    shippingAddress: "",
                    deliveryDate: "3 days",
                    contactInfo: 'tnm_contact',
                    supportLink: process.env.SUPPORT_LINK
                };
                // Get email content with dynamic data
                const emailContent = (0, mailer_1.generateContent)('/mails/receipt.html', replacements);
                (0, nodemailer_1.sendMail)({ to: email, type: 'html', subject: 'TNM Acceptance fee', content: emailContent });
                // crete sudent_fee data
                if (status) {
                    // const strm = stream || Stream.STANDARD;
                    const paid = metadata.fee.amount_due === metadata.fee.amount_paid;
                    const programme = yield this.studentAdapter.getProgrammeByStream(stream);
                    const diet = yield this.studentAdapter.getDietById(session.current_diet.id);
                    const adm_no = yield (0, factory_1.generateRegNo)(programme, diet);
                    const password = yield (0, factory_1.encodeLastName)(last_name);
                    const level = stream == enum_1.Stream.BASIC || stream == enum_1.Stream.ADVANCED ? enum_1.Level._13 : enum_1.Level._100;
                    const student_id = yield this.studentAdapter.DBCreateStudent(auth_user, password, adm_no, paid, level);
                    // await this.feeAdapter.DBCreateAspirantFee(auth_user.id, metadata.fee, metadata.fee.amount, strm, ref, session);
                    // await this.feeAdapter.DBCreateAspirantFee(auth_user.id, metadata.card_fee, metadata.card_fee.amount, strm, ref, session);
                    // await this.feeAdapter.DBCreateAspirantFee(auth_user.id, metadata.acceptance_fee, metadata.acceptance_fee.amount, strm, ref, session);
                    const amount_paid = metadata.fee.amount - (Number(metadata.card_fee.amount) + Number(metadata.acceptance_fee.amount));
                    yield this.feeAdapter.DBCreateStudentFee(student_id, metadata.fee, amount_paid, stream, ref, programme.id, session, false);
                    yield this.feeAdapter.DBCreateStudentFee(student_id, metadata.card_fee, metadata.card_fee.amount, stream, ref, programme.id, session, false);
                    yield this.feeAdapter.DBCreateStudentFee(student_id, metadata.acceptance_fee, metadata.acceptance_fee.amount, stream, ref, programme.id, session, false);
                    // transfer all fee table to student_fee table;
                    (0, nodemailer_1.sendMail)({ to: email, type: 'html', subject: 'Congratulations!!', content: `Your admission number is ${adm_no}. Kindly login with the last part of the admission number as the matric number and your surname as the passwoord` });
                }
                return (0, api_response_1.success)(res, status);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        // STUDENTTTTTTTT
        this.getOutstandingFee = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { session, auth_user } = req.body;
                const { returning, split } = req.params;
                const data = yield this.studentAdapter.DBGetEnrollmentData(auth_user.id);
                // if(data.session_id === session.id), that means it's not a returning but wants to pay balance for the current session
                const residual = data.session_id === session.id;
                const fees = yield this.feeAdapter.DBGetOutstandingFee(auth_user.id, session.id, auth_user.stream, residual);
                console.log(fees);
                // const spt = split === true
                // if (spt && fee.upfront) {
                //     console.log('should')
                //     fee.amount = 60 / 100 * fee.amount;
                // }
                return (0, api_response_1.success)(res, fees);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.payOutstandingFee = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { session, auth_user } = req.body;
                const { first_name, last_name, email, stream } = auth_user;
                const data = yield this.studentAdapter.DBGetEnrollmentData(auth_user.id);
                const residual = data.session_id === session.id;
                const fees = yield this.feeAdapter.DBGetOutstandingFee(auth_user.id, session.id, auth_user.stream, residual);
                let amount = 0;
                // let receipt: { [key: string]: object } = {};
                for (let fee of fees) {
                    amount += fee.amount;
                    // receipt[fee.description] = fee;
                }
                amount = (amount + (0, factory_1.calculateCharges)(amount)) * 100;
                const transactionID = (0, factory_1.generateTransactionID)();
                fees[transactionID] = transactionID;
                const metadata = {
                    fees,
                    customer: { first_name, last_name, email },
                    stream
                };
                const payment = yield (0, axios_1.default)({
                    method: 'POST',
                    url: `https://api.paystack.co/transaction/initialize`,
                    headers: {
                        "Content-Type": "application/json",
                        Authorization: `Bearer ${process.env.PAYSTACK_SECRET_KEY}`
                    },
                    data: { email, amount: Math.ceil(amount), reference: transactionID, metadata, callback_url: `${process.env.TNM_CLIENT_URL}/student/fees/verify?fee_ids=${fees.map(fee => fee.id)}&stream=${stream}&residual=${residual}` },
                });
                return (0, api_response_1.success)(res, payment.data.data.authorization_url);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.verifyOutstandingFeePayment = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user, session } = req.body;
                const { reference, stream, residual } = req.query;
                const { id, email } = auth_user;
                const verify = yield (0, axios_1.default)({
                    method: 'GET',
                    url: `https://api.paystack.co/transaction/verify/${reference}`,
                    headers: {
                        "Content-Type": "application/json",
                        Authorization: `Bearer ${process.env.PAYSTACK_SECRET_KEY}`
                    },
                });
                const { status, amount, gateway_response, requested_amount, channel, metadata, message } = verify.data.data;
                console.log(status, 'status');
                if (status !== 'success')
                    return (0, api_response_1.badRequest)(res, gateway_response);
                if (amount !== requested_amount)
                    throw new Error('Invalid fund');
                const ref = reference;
                // await this.pay_refAdapter.DBSavePaymentRef(email, ref, { fees: metadata.fees });
                const replacements = {
                    userName: `${auth_user.first_name} ${auth_user.last_name}`,
                    companyName: process.env.COMPANY_NAME,
                    orderID: reference,
                    orderDate: new Date(),
                    paymentMethod: channel,
                    shippingAddress: "",
                    deliveryDate: "3 days",
                    contactInfo: 'cowry_contact',
                    supportLink: process.env.SUPPORT_LINK
                };
                // Get email content with dynamic data
                const emailContent = (0, mailer_1.generateContent)('/mails/receipt.html', replacements);
                (0, nodemailer_1.sendMail)({ to: email, type: 'html', subject: 'Please verify your email', content: emailContent });
                if (status) {
                    const programme = yield this.studentAdapter.getProgrammeByStream(auth_user.stream);
                    const resid = residual === true;
                    for (let fee of metadata.fees) {
                        yield this.feeAdapter.DBCreateStudentFee(auth_user.id, fee, fee.amount, auth_user.stream, ref, programme.id, session, resid);
                    }
                }
                return (0, api_response_1.successAction)(res, status);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        // W E B H O O K
        this.paymentWebhook = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const hmac = node_forge_1.default.hmac.create();
                hmac.start('sha512', process.env.PAYSTACK_SECRET_KEY);
                hmac.update(JSON.stringify(req.body));
                const hash = hmac.digest().toHex();
                console.log(hash, 'hash');
                console.log(req.headers['x-paystack-signature'], 'req.headers');
                (0, api_response_1.successAction)(res);
                // Retrieve the request's body
                const event = req.body;
                // if(event.event !== 'charge.success') return successAction(res);
                if (hash !== req.headers['x-paystack-signature'] && event.event !== 'charge.success') {
                    console.log('Not from paystack');
                    // return badRequest(res, null,)
                    return;
                }
                const { status, amount, gateway_response, requested_amount, channel, metadata, message } = event.data;
                if (status !== 'success')
                    return (0, api_response_1.badRequest)(res, gateway_response);
                if (amount !== requested_amount)
                    throw new Error('Invalid fund');
                console.log(req.body);
                const reference = event.data.reference;
                // const verify = await axios({
                //     method: 'GET',
                //     url: `https://api.paystack.co/transaction/verify/${reference}`,
                //     headers: {
                //         "Content-Type": "application/json",
                //         Authorization: `Bearer ${process.env.PAYSTACK_SECRET_KEY}`
                //     },
                // });
                console.log(metadata, 'metadata');
                console.log(metadata.invoice_type, 'Webhook fee type to be firedddddddd');
                switch (metadata.invoice_type) {
                    case enum_1.Invoice_Type.FORM:
                        this.processFormPayment(event.session, amount, metadata, reference);
                        break;
                    case enum_1.Invoice_Type.PUTME:
                        this.processPUTMEPayment(event.session, amount, metadata, reference);
                        break;
                    case enum_1.Invoice_Type.PART_FORM:
                        this.processPartApplicationPayment(event.session, amount, metadata, reference);
                        break;
                    case enum_1.Invoice_Type.ACCEPTANCE:
                        this.processAcceptanceFee(event.session, amount, metadata, reference);
                        break;
                    case enum_1.Invoice_Type.TUITION:
                        this.processTution(event.session, amount, metadata, reference);
                        break;
                    case enum_1.Invoice_Type.ACCEPTANCE_TUTION:
                        this.processAcceptanceAndTutionFee(event.session, amount, metadata, reference);
                        break;
                    default:
                        console.log('COULD NOT FOUND A MATCHING FEE TYPE');
                        break;
                }
                const { email, first_name, last_name, middle_name, DOB, phone } = metadata.customer;
                const ref = reference;
                // await this.pay_refAdapter.DBSavePaymentRef(email, ref, metadata.fee);
                const replacements = {
                    userName: `${first_name} ${last_name}`,
                    companyName: process.env.COMPANY_NAME || 'TNM Media Academy',
                    orderID: ref,
                    orderDate: new Date(),
                    paymentMethod: channel,
                    shippingAddress: "",
                    deliveryDate: "3 days",
                    contactInfo: 'tnm_contact',
                    supportLink: process.env.SUPPORT_LINK
                };
                // Get email content with dynamic data
                const emailContent = (0, mailer_1.generateContent)('/mails/receipt.html', replacements);
                (0, nodemailer_1.sendMail)({ to: email, type: 'html', subject: 'Payment Receipt', content: emailContent });
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
    }
};
FeeController = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [feeAdapter_1.default,
        pay_refAdapter_1.default,
        studentAdapter_1.default,
        aspirantAdapter_1.default])
], FeeController);
;
exports.default = FeeController;
